/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.command.handler;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.extract.master.command.ICommandParam;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.engine.command.handler.AbstractCommandHandler;
import org.apache.dolphinscheduler.server.master.engine.graph.IWorkflowGraph;
import org.apache.dolphinscheduler.server.master.engine.graph.WorkflowExecutionGraph;
import org.apache.dolphinscheduler.server.master.engine.graph.WorkflowGraphTopologyLogicalVisitor;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.TaskExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.TaskExecutionRunnableBuilder;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteContext;
import org.apache.dolphinscheduler.service.expand.CuringParamsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class RunWorkflowCommandHandler
extends AbstractCommandHandler {
    @Autowired
    private WorkflowInstanceDao workflowInstanceDao;
    @Autowired
    private TaskInstanceDao taskInstanceDao;
    @Autowired
    private MasterConfig masterConfig;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CuringParamsService curingParamsService;

    @Override
    protected void assembleWorkflowInstance(WorkflowExecuteContext.WorkflowExecuteContextBuilder workflowExecuteContextBuilder) {
        WorkflowDefinition workflowDefinition = workflowExecuteContextBuilder.getWorkflowDefinition();
        Command command = workflowExecuteContextBuilder.getCommand();
        WorkflowInstance workflowInstance = (WorkflowInstance)this.workflowInstanceDao.queryById((Serializable)Integer.valueOf(command.getWorkflowInstanceId()));
        workflowInstance.setStateWithDesc(WorkflowExecutionStatus.RUNNING_EXECUTION, command.getCommandType().name());
        workflowInstance.setHost(this.masterConfig.getMasterAddress());
        workflowInstance.setCommandParam(command.getCommandParam());
        workflowInstance.setGlobalParams(this.mergeCommandParamsWithWorkflowParams(command, workflowDefinition));
        this.workflowInstanceDao.upsertWorkflowInstance(workflowInstance);
        workflowExecuteContextBuilder.setWorkflowInstance(workflowInstance);
    }

    @Override
    protected void assembleWorkflowExecutionGraph(WorkflowExecuteContext.WorkflowExecuteContextBuilder workflowExecuteContextBuilder) {
        IWorkflowGraph workflowGraph = workflowExecuteContextBuilder.getWorkflowGraph();
        WorkflowExecutionGraph workflowExecutionGraph = new WorkflowExecutionGraph();
        BiConsumer<String, Set<String>> taskExecutionRunnableCreator = (task, successors) -> {
            TaskExecutionRunnableBuilder taskExecutionRunnableBuilder = TaskExecutionRunnableBuilder.builder().workflowExecutionGraph(workflowExecutionGraph).workflowDefinition(workflowExecuteContextBuilder.getWorkflowDefinition()).project(workflowExecuteContextBuilder.getProject()).workflowInstance(workflowExecuteContextBuilder.getWorkflowInstance()).taskDefinition(workflowGraph.getTaskNodeByName((String)task)).workflowEventBus(workflowExecuteContextBuilder.getWorkflowEventBus()).applicationContext(this.applicationContext).build();
            workflowExecutionGraph.addNode(new TaskExecutionRunnable(taskExecutionRunnableBuilder));
            workflowExecutionGraph.addEdge((String)task, (Set<String>)successors);
        };
        WorkflowGraphTopologyLogicalVisitor workflowGraphTopologyLogicalVisitor = WorkflowGraphTopologyLogicalVisitor.builder().taskDependType(workflowExecuteContextBuilder.getWorkflowInstance().getTaskDependType()).onWorkflowGraph(workflowGraph).fromTask(this.parseStartNodesFromWorkflowInstance(workflowExecuteContextBuilder)).doVisitFunction(taskExecutionRunnableCreator).build();
        workflowGraphTopologyLogicalVisitor.visit();
        workflowExecutionGraph.removeUnReachableEdge();
        workflowExecuteContextBuilder.setWorkflowExecutionGraph(workflowExecutionGraph);
    }

    private String mergeCommandParamsWithWorkflowParams(Command command, WorkflowDefinition workflowDefinition) {
        List commandParams = Optional.ofNullable(JSONUtils.parseObject((String)command.getCommandParam(), ICommandParam.class)).map(ICommandParam::getCommandParams).orElse(null);
        List globalParamsList = JSONUtils.toList((String)workflowDefinition.getGlobalParams(), Property.class);
        HashMap finalParams = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)globalParamsList)) {
            globalParamsList.forEach(globalParam -> finalParams.put(globalParam.getProp(), globalParam));
        }
        if (CollectionUtils.isNotEmpty((Collection)commandParams)) {
            commandParams.forEach(commandParam -> finalParams.put(commandParam.getProp(), commandParam));
        }
        return JSONUtils.toJsonString(finalParams.values());
    }

    @Override
    public CommandType commandType() {
        return CommandType.START_PROCESS;
    }
}

