/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.crypto;

import com.qcloud.cos.internal.crypto.CipherLite;
import com.qcloud.cos.internal.crypto.ContentCryptoScheme;
import com.qcloud.cos.internal.crypto.GCMCipherLite;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

class AesGcm
extends ContentCryptoScheme {
    AesGcm() {
    }

    @Override
    String getKeyGeneratorAlgorithm() {
        return "AES";
    }

    @Override
    String getCipherAlgorithm() {
        return "AES/GCM/NoPadding";
    }

    @Override
    int getKeyLengthInBits() {
        return 256;
    }

    @Override
    int getBlockSizeInBytes() {
        return 16;
    }

    @Override
    int getIVLengthInBytes() {
        return 12;
    }

    @Override
    long getMaxPlaintextSize() {
        return 0xFFFFFFFE0L;
    }

    @Override
    byte[] getIV() {
        return null;
    }

    @Override
    void setIV(byte[] iv) {
    }

    @Override
    int getTagLengthInBits() {
        return 128;
    }

    @Override
    String getSpecificCipherProvider() {
        return "BC";
    }

    @Override
    CipherLite createAuxillaryCipher(SecretKey cek, byte[] ivOrig, int cipherMode, Provider securityProvider, long startingBytePos) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        byte[] iv = AES_CTR.adjustIV(ivOrig, startingBytePos);
        return AES_CTR.createCipherLite(cek, iv, cipherMode, securityProvider);
    }

    @Override
    protected CipherLite newCipherLite(Cipher cipher, SecretKey cek, int cipherMode) {
        return new GCMCipherLite(cipher, cek, cipherMode);
    }
}

