/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.search.models;

import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.search.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.search.fluent.models.SearchServiceProperties;
import com.azure.resourcemanager.search.fluent.models.SharedPrivateLinkResourceInner;
import com.azure.resourcemanager.search.models.HostingMode;
import com.azure.resourcemanager.search.models.Identity;
import com.azure.resourcemanager.search.models.NetworkRuleSet;
import com.azure.resourcemanager.search.models.ProvisioningState;
import com.azure.resourcemanager.search.models.PublicNetworkAccess;
import com.azure.resourcemanager.search.models.SearchServiceStatus;
import com.azure.resourcemanager.search.models.Sku;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class SearchServiceUpdate
extends ProxyResource {
    @JsonProperty(value="properties")
    private SearchServiceProperties innerProperties;
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="location")
    private String location;
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;
    @JsonProperty(value="identity")
    private Identity identity;

    private SearchServiceProperties innerProperties() {
        return this.innerProperties;
    }

    public Sku sku() {
        return this.sku;
    }

    public SearchServiceUpdate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public String location() {
        return this.location;
    }

    public SearchServiceUpdate withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public SearchServiceUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Identity identity() {
        return this.identity;
    }

    public SearchServiceUpdate withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public Integer replicaCount() {
        return this.innerProperties() == null ? null : this.innerProperties().replicaCount();
    }

    public SearchServiceUpdate withReplicaCount(Integer replicaCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SearchServiceProperties();
        }
        this.innerProperties().withReplicaCount(replicaCount);
        return this;
    }

    public Integer partitionCount() {
        return this.innerProperties() == null ? null : this.innerProperties().partitionCount();
    }

    public SearchServiceUpdate withPartitionCount(Integer partitionCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SearchServiceProperties();
        }
        this.innerProperties().withPartitionCount(partitionCount);
        return this;
    }

    public HostingMode hostingMode() {
        return this.innerProperties() == null ? null : this.innerProperties().hostingMode();
    }

    public SearchServiceUpdate withHostingMode(HostingMode hostingMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SearchServiceProperties();
        }
        this.innerProperties().withHostingMode(hostingMode);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public SearchServiceUpdate withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SearchServiceProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public SearchServiceStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public String statusDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().statusDetails();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public NetworkRuleSet networkRuleSet() {
        return this.innerProperties() == null ? null : this.innerProperties().networkRuleSet();
    }

    public SearchServiceUpdate withNetworkRuleSet(NetworkRuleSet networkRuleSet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SearchServiceProperties();
        }
        this.innerProperties().withNetworkRuleSet(networkRuleSet);
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public List<SharedPrivateLinkResourceInner> sharedPrivateLinkResources() {
        return this.innerProperties() == null ? null : this.innerProperties().sharedPrivateLinkResources();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }
}

