/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appplatform.fluent.RuntimeVersionsClient;
import com.azure.resourcemanager.appplatform.fluent.models.AvailableRuntimeVersionsInner;
import com.azure.resourcemanager.appplatform.implementation.AppPlatformManagementClientImpl;
import reactor.core.publisher.Mono;

public final class RuntimeVersionsClientImpl
implements RuntimeVersionsClient {
    private final RuntimeVersionsService service;
    private final AppPlatformManagementClientImpl client;

    RuntimeVersionsClientImpl(AppPlatformManagementClientImpl client) {
        this.service = (RuntimeVersionsService)RestProxy.create(RuntimeVersionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AvailableRuntimeVersionsInner>> listRuntimeVersionsWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listRuntimeVersions(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AvailableRuntimeVersionsInner>> listRuntimeVersionsWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listRuntimeVersions(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AvailableRuntimeVersionsInner> listRuntimeVersionsAsync() {
        return this.listRuntimeVersionsWithResponseAsync().flatMap(res -> Mono.justOrEmpty((Object)((AvailableRuntimeVersionsInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AvailableRuntimeVersionsInner listRuntimeVersions() {
        return (AvailableRuntimeVersionsInner)this.listRuntimeVersionsAsync().block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AvailableRuntimeVersionsInner> listRuntimeVersionsWithResponse(Context context) {
        return (Response)this.listRuntimeVersionsWithResponseAsync(context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AppPlatformManagemen")
    private static interface RuntimeVersionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.AppPlatform/runtimeVersions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AvailableRuntimeVersionsInner>> listRuntimeVersions(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

