/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.spring.extended.controller.config;

import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.spring.extended.controller.KubernetesInformerFactoryProcessor;
import io.kubernetes.client.spring.extended.controller.config.ConditionalOnKubernetesInformerEnabled;
import io.kubernetes.client.spring.extended.controller.config.KubernetesInformerProperties;
import io.kubernetes.client.util.ClientBuilder;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnKubernetesInformerEnabled
@EnableConfigurationProperties(value={KubernetesInformerProperties.class})
public class KubernetesInformerAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesInformerAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public ApiClient defaultApiClient() throws IOException {
        try {
            ApiClient apiClient = ClientBuilder.defaultClient();
            return apiClient;
        }
        catch (Exception e) {
            LOGGER.warn("Could not create a Kubernetes ApiClient from either a cluster or standard environment. Will return one that always connects to localhost:8080", (Throwable)e);
            return new ClientBuilder().build();
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public SharedInformerFactory sharedInformerFactory() {
        return new SharedInformerFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    public static KubernetesInformerFactoryProcessor kubernetesInformerConfigurer() {
        return new KubernetesInformerFactoryProcessor();
    }
}

