/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.sql.whereclausebuilder;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.torque.TorqueException;
import org.apache.torque.adapter.Adapter;
import org.apache.torque.criteria.PreparedStatementPart;
import org.apache.torque.sql.Query;
import org.apache.torque.sql.SqlBuilder;
import org.apache.torque.sql.WhereClauseExpression;
import org.apache.torque.sql.whereclausebuilder.AbstractWhereClausePsPartBuilder;
import org.apache.torque.sql.whereclausebuilder.WhereClausePsPartBuilder;

public class EnumValueBuilder
extends AbstractWhereClausePsPartBuilder {
    @Override
    public PreparedStatementPart buildPs(WhereClauseExpression whereClausePart, boolean ignoreCase, Query query, Adapter adapter) throws TorqueException {
        if (whereClausePart.getLValue() instanceof Enum) {
            whereClausePart.setLValue(this.getWrappedValue(whereClausePart.getLValue()));
        }
        if (whereClausePart.getRValue() instanceof Enum) {
            whereClausePart.setRValue(this.getWrappedValue(whereClausePart.getRValue()));
        }
        for (WhereClausePsPartBuilder builder : SqlBuilder.getWhereClausePsPartBuilders()) {
            if (!builder.isApplicable(whereClausePart, adapter)) continue;
            return builder.buildPs(whereClausePart, ignoreCase, query, adapter);
        }
        throw new RuntimeException("No handler found for whereClausePart " + String.valueOf(whereClausePart));
    }

    protected Object getWrappedValue(Object wrapped) throws TorqueException {
        Method getValueMethod;
        Class<?> clazz = wrapped.getClass();
        try {
            getValueMethod = clazz.getMethod("getValue", new Class[0]);
        }
        catch (SecurityException e) {
            throw new TorqueException("Could not access the getValue() method of the class of an enum value, " + clazz.getName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new TorqueException("An enum is used as Criterion value but its class, " + clazz.getName() + ", does not have a parameterless getValue() method");
        }
        if (getValueMethod.getReturnType().equals(Void.class)) {
            throw new TorqueException("An enum is given as Criterion value but its class, " + clazz.getName() + ", has a parameterless getValue() method which retirsns void. It should return the wrapped type instead.");
        }
        try {
            return getValueMethod.invoke(wrapped, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new TorqueException("Could not invoke the getValue() method of the class of an enum value, " + clazz.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new TorqueException("Could not access the getValue() method of the class of an enum value, " + clazz.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new TorqueException("The getValue() method of the class of an enum value, " + clazz.getName() + " threw an exception", e);
        }
    }

    @Override
    public boolean isApplicable(WhereClauseExpression whereClauseExpression, Adapter adapter) {
        return whereClauseExpression.getLValue() instanceof Enum || whereClauseExpression.getRValue() instanceof Enum;
    }
}

