/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.externalvars;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.exceptions.ThrowsSDE;
import org.apache.daffodil.lib.externalvars.Binding;
import org.apache.daffodil.lib.externalvars.Binding$;
import org.apache.daffodil.lib.iapi.URISchemaSource$;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.lib.xml.DaffodilXMLLoader;
import org.apache.daffodil.lib.xml.XMLUtils$;
import org.apache.daffodil.runtime1.processors.VariableMap;
import org.apache.daffodil.runtime1.processors.VariableUtils$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Queue$;
import scala.collection.immutable.Seq;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.jdk.CollectionConverters$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.xml.Node;

public final class ExternalVariablesLoader$
implements Serializable {
    public static final ExternalVariablesLoader$ MODULE$ = new ExternalVariablesLoader$();

    private ExternalVariablesLoader$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ExternalVariablesLoader$.class);
    }

    public VariableMap loadVariables(Seq<Binding> bindings, ThrowsSDE referringContext, VariableMap vmap) {
        if (referringContext == null) {
            throw Assert$.MODULE$.usageError2("loadVariables expects 'referringContext' to not be null!", "referringContext.!=(null)");
        }
        VariableUtils$.MODULE$.setExternalVariables(vmap, bindings, referringContext);
        return vmap;
    }

    public Queue<Binding> mapToBindings(Map<String, String> vars) {
        scala.collection.mutable.Iterable varsKVP = (scala.collection.mutable.Iterable)CollectionConverters$.MODULE$.MapHasAsScala(vars).asScala().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                String value = (String)tuple2._2();
                return Binding$.MODULE$.apply(name, value);
            }
            throw new MatchError((Object)tuple2);
        });
        return Queue$.MODULE$.empty().enqueueAll((Iterable)varsKVP);
    }

    public Queue<Binding> uriToBindings(URI uri) {
        if (uri == null) {
            throw Assert$.MODULE$.usageError("uri.ne(null)");
        }
        File file = new File(uri);
        return this.fileToBindings(file);
    }

    public Queue<Binding> fileToBindings(File file) {
        if (file == null) {
            throw Assert$.MODULE$.usageError("file.ne(null)");
        }
        String enc = Misc$.MODULE$.determineEncoding(file);
        BufferedSource input = Source$.MODULE$.fromURI(file.toURI(), Codec$.MODULE$.string2codec(enc));
        DaffodilXMLLoader ldr = new DaffodilXMLLoader();
        URI dafextURI = XMLUtils$.MODULE$.dafextURI();
        Node node = ldr.load(URISchemaSource$.MODULE$.apply(file, file.toURI()), (Option<URI>)Some$.MODULE$.apply((Object)dafextURI), ldr.load$default$3());
        return this.nodeToBindings(node);
    }

    public Queue<Binding> nodeToBindings(Node node) {
        if (node == null) {
            throw Assert$.MODULE$.usageError("node.ne(null)");
        }
        Seq<Binding> newBindings = Binding$.MODULE$.getBindings(node);
        ObjectRef res = ObjectRef.create((Object)Queue$.MODULE$.empty());
        newBindings.foreach((Function1)(JProcedure1 & Serializable)b -> {
            res$1.elem = ((Queue)res$1.elem).enqueue(b);
        });
        return (Queue)res.elem;
    }
}

