/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.lib.util;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.schema.annotation.props.gen.BitOrder;
import org.apache.daffodil.lib.schema.annotation.props.gen.BitOrder$MostSignificantBitFirst$;
import scala.Byte$;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Range;
import scala.reflect.ClassTag$;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.java8.JFunction1;

public final class Bits$
implements Serializable {
    private static final IndexedSeq maskR;
    private static final IndexedSeq maskL;
    private static final int[] LSBitTable;
    public static final Bits$ MODULE$;

    private Bits$() {
    }

    static {
        MODULE$ = new Bits$();
        maskR = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 8).map((Function1)(JFunction1.mcII.sp & Serializable)bits -> (1 << bits) - 1);
        maskL = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 8).map((Function1)(JFunction1.mcII.sp & Serializable)bits -> (1 << bits) - 1 << 8 - bits);
        Range.Inclusive ints = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 255);
        IndexedSeq table = ints.map((Function1)(JFunction1.mcII.sp & Serializable)_$2 -> this.asLSBitFirst1(_$2));
        LSBitTable = (int[])table.toArray(ClassTag$.MODULE$.apply(Integer.TYPE));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Bits$.class);
    }

    public IndexedSeq<Object> maskR() {
        return maskR;
    }

    public IndexedSeq<Object> maskL() {
        return maskL;
    }

    public int asUnsignedByte(byte b) {
        if (b < 0) {
            return 256 + b;
        }
        return Byte$.MODULE$.byte2int(b);
    }

    public int asUnsignedByte(long b) {
        return (int)(b & 0xFFL);
    }

    public byte asSignedByte(long i) {
        if (i < 0L) {
            throw Assert$.MODULE$.usageError("i.>=(0)");
        }
        long res = i > 127L ? i - 256L : i;
        return (byte)res;
    }

    public int asLSBitFirst1(int b) {
        if (b < 0) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        IntRef res = IntRef.create((int)0);
        IntRef bits = IntRef.create((int)b);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 7).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            res$1.elem = res$1.elem << 1 | bits$1.elem & 1;
            bits$1.elem >>= 1;
        });
        return res.elem;
    }

    public int[] LSBitTable() {
        return LSBitTable;
    }

    public int asLSBitFirst(int b) {
        return this.LSBitTable()[b];
    }

    public byte asLSBitFirst(byte b) {
        return this.asSignedByte(Int$.MODULE$.int2long(this.LSBitTable()[this.asUnsignedByte(b)]));
    }

    public void reverseBytesAndReverseBits(ByteBuffer bb) {
        this.reverseBytes(bb);
        this.reverseBitsWithinBytes(bb);
    }

    public void reverseBitsWithinBytes(ByteBuffer bb) {
        if (bb.position() != 0) {
            throw Assert$.MODULE$.usageError("bb.position().==(0)");
        }
        int len = bb.remaining();
        for (int i = 0; i < len; ++i) {
            bb.put(i, this.asLSBitFirst(bb.get(i)));
        }
    }

    public void reverseBytes(byte[] a, int length) {
        boolean i = false;
        int lowerIndex = 0;
        for (int upperIndex = length - 1; lowerIndex < upperIndex; ++lowerIndex, --upperIndex) {
            byte tmp = a[lowerIndex];
            a[lowerIndex] = a[upperIndex];
            a[upperIndex] = tmp;
        }
    }

    public void reverseBytes(ByteBuffer bb) {
        if (bb.position() != 0) {
            throw Assert$.MODULE$.usageError("bb.position().==(0)");
        }
        boolean i = false;
        int lowerIndex = bb.position();
        for (int upperIndex = bb.remaining() - 1; lowerIndex < upperIndex; ++lowerIndex, --upperIndex) {
            byte tmp = bb.get(lowerIndex);
            bb.put(lowerIndex, bb.get(upperIndex));
            bb.put(upperIndex, tmp);
        }
    }

    public void shiftLeft(byte[] ba, int bitsToShift) {
        Object object;
        if (bitsToShift >= 8) {
            throw Assert$.MODULE$.usageError("bitsToShift.<(8)");
        }
        Object object2 = Predef$.MODULE$.byteArrayOps(ba);
        if (ArrayOps$.MODULE$.size$extension(object2) <= 0) {
            throw Assert$.MODULE$.usageError("scala.Predef.byteArrayOps(ba).size.>(0)");
        }
        int curShift = bitsToShift;
        int nextShift = 8 - bitsToShift;
        int curByte = this.asUnsignedByte(ba[0]);
        for (int i = 0; i < ArrayOps$.MODULE$.size$extension(object = Predef$.MODULE$.byteArrayOps(ba)) - 1; ++i) {
            int nextByte = this.asUnsignedByte(ba[i + 1]);
            ba[i] = this.asSignedByte(Int$.MODULE$.int2long(curByte << curShift & 0xFF | nextByte >>> nextShift));
            curByte = nextByte;
        }
        ba[i] = this.asSignedByte(Int$.MODULE$.int2long(curByte << curShift & 0xFF));
    }

    public void shiftLeft(ByteBuffer bb, int n) {
        if (n >= 8) {
            throw Assert$.MODULE$.usageError("n.<(8)");
        }
        if (bb.position() != 0) {
            throw Assert$.MODULE$.usageError("bb.position().==(0)");
        }
        int leftBits = 0;
        int mask = (1 << n) - 1;
        for (int i = bb.remaining() - 1; i >= 0; --i) {
            int rightBits = leftBits >>> 8 & mask;
            int b = this.asUnsignedByte(bb.get(i));
            leftBits = b << n;
            int shiftedByte = (leftBits | rightBits) & 0xFF;
            bb.put(i, this.asSignedByte(Int$.MODULE$.int2long(shiftedByte)));
        }
    }

    public void shiftRight(ByteBuffer bb, int n) {
        if (n >= 8 || n < 0) {
            throw Assert$.MODULE$.usageError("n.<(8).&&(n.>=(0))");
        }
        if (bb.position() != 0) {
            throw Assert$.MODULE$.usageError("bb.position().==(0)");
        }
        if (n == 0) {
            return;
        }
        int rightBits = 0;
        int mask = (1 << n) - 1 & 0xFF;
        for (int i = 0; i < bb.remaining(); ++i) {
            int leftBits = rightBits << 8 - n;
            int b = this.asUnsignedByte(bb.get(i));
            rightBits = b & mask;
            int v = (b >>> n | leftBits) & 0xFF;
            bb.put(i, this.asSignedByte(Int$.MODULE$.int2long(v)));
        }
    }

    public void shiftToHigherBitPosition(BitOrder bitOrder, ByteBuffer bb, int n) {
        if (bitOrder == BitOrder$MostSignificantBitFirst$.MODULE$) {
            this.shiftRight(bb, n);
            return;
        }
        this.reverseBitsWithinBytes(bb);
        this.shiftRight(bb, n);
        this.reverseBitsWithinBytes(bb);
    }

    public String asBits(int unsignedByte) {
        return String.format("%8s", RichInt$.MODULE$.toBinaryString$extension(Predef$.MODULE$.intWrapper(unsignedByte))).replace(' ', '0');
    }

    public long signExtend(long l, int bitLength) {
        if (bitLength <= 0 || bitLength > 64) {
            throw Assert$.MODULE$.usageError("bitLength.>(0).&&(bitLength.<=(64))");
        }
        if (bitLength == 1) {
            return l;
        }
        int shift = 64 - bitLength;
        long res = l << shift >> shift;
        return res;
    }

    public long unSignExtend(long l, int bitLength) {
        if (bitLength <= 0 || bitLength > 64) {
            throw Assert$.MODULE$.usageError("bitLength.>(0).&&(bitLength.<=(64))");
        }
        long mask = bitLength == 64 ? -1L : (1L << bitLength) - 1L;
        return l & mask;
    }

    public long roundUpBitToBytePosition(long bitPos0b) {
        long bytePos0b = bitPos0b >> 3;
        if ((bitPos0b & 7L) == 0L) {
            return bytePos0b;
        }
        return bytePos0b + 1L;
    }

    public int littleEndianBitValue(int bitPosition, int bitStringLength) {
        if (bitPosition < 1) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        if (bitStringLength < 1) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        if (bitStringLength < bitPosition) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        int numBitsInFinalPartialByte = bitStringLength % 8;
        int numBitsInWholeBytes = bitStringLength - numBitsInFinalPartialByte;
        int bitPosInByte = (bitPosition - 1) % 8 + 1;
        int widthOfActiveBitsInByte = bitPosition <= numBitsInWholeBytes ? 8 : numBitsInFinalPartialByte;
        int placeValueExponentOfBitInByte = widthOfActiveBitsInByte - bitPosInByte;
        int bitValueInByte = 1 << placeValueExponentOfBitInByte;
        int byteNumZeroBased = (bitPosition - 1) / 8;
        int scaleFactorForBytePosition = 1 << 8 * byteNumZeroBased;
        int bitValue = bitValueInByte * scaleFactorForBytePosition;
        return bitValue;
    }
}

