/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.idp;

import jakarta.ws.rs.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.oauth2.common.AbstractFormImplicitResponse;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthRedirectionState;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.apache.cxf.rs.security.oidc.idp.FormHybridResponse;
import org.apache.cxf.rs.security.oidc.idp.OidcAuthorizationCodeService;
import org.apache.cxf.rs.security.oidc.idp.OidcImplicitService;

@Path(value="authorize-hybrid")
public class OidcHybridService
extends OidcImplicitService {
    private OidcAuthorizationCodeService codeService;

    public OidcHybridService() {
        this(false);
    }

    public OidcHybridService(boolean hybridOnly) {
        super(OidcHybridService.getResponseTypes(hybridOnly), "implicit");
    }

    private static Set<String> getResponseTypes(boolean hybridOnly) {
        ArrayList<String> types = new ArrayList<String>();
        types.addAll(Arrays.asList("code token", "code id_token", "code id_token token"));
        if (!hybridOnly) {
            types.add("id_token");
            types.add("id_token token");
        }
        return new HashSet<String>(types);
    }

    @Override
    protected boolean canAccessTokenBeReturned(String responseType) {
        return "id_token token".equals(responseType) || "code id_token token".equals(responseType) || "code token".equals(responseType);
    }

    @Override
    protected StringBuilder prepareRedirectResponse(OAuthRedirectionState state, Client client, List<String> requestedScope, List<String> approvedScope, UserSubject userSubject, ServerAccessToken preAuthorizedToken) {
        ServerAuthorizationCodeGrant codeGrant = this.prepareHybrideCode(state, client, requestedScope, approvedScope, userSubject, preAuthorizedToken);
        StringBuilder sb = super.prepareRedirectResponse(state, client, requestedScope, approvedScope, userSubject, preAuthorizedToken);
        if (codeGrant != null) {
            sb.append('&');
            sb.append("code").append('=').append(codeGrant.getCode());
        }
        return sb;
    }

    @Override
    protected AbstractFormImplicitResponse prepareFormResponse(OAuthRedirectionState state, Client client, List<String> requestedScope, List<String> approvedScope, UserSubject userSubject, ServerAccessToken preAuthorizedToken) {
        ServerAuthorizationCodeGrant codeGrant = this.prepareHybrideCode(state, client, requestedScope, approvedScope, userSubject, preAuthorizedToken);
        AbstractFormImplicitResponse implResp = super.prepareFormResponse(state, client, requestedScope, approvedScope, userSubject, preAuthorizedToken);
        FormHybridResponse response = new FormHybridResponse();
        response.setResponseType(state.getResponseType());
        response.setRedirectUri(state.getRedirectUri());
        response.setState(state.getState());
        response.setImplicitResponse(implResp);
        if (codeGrant != null) {
            response.setCode(codeGrant.getCode());
        }
        return response;
    }

    protected ServerAuthorizationCodeGrant prepareHybrideCode(OAuthRedirectionState state, Client client, List<String> requestedScope, List<String> approvedScope, UserSubject userSubject, ServerAccessToken preAuthorizedToken) {
        ServerAuthorizationCodeGrant codeGrant = null;
        if (state.getResponseType() != null && state.getResponseType().startsWith("code")) {
            codeGrant = this.codeService.getGrantRepresentation(state, client, requestedScope, approvedScope, userSubject, preAuthorizedToken);
            JAXRSUtils.getCurrentMessage().getExchange().put((Object)"code", (Object)codeGrant.getCode());
        }
        return codeGrant;
    }

    public void setCodeService(OidcAuthorizationCodeService codeService) {
        this.codeService = codeService;
    }
}

