/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.io.output;

import static org.junit.jupiter.api.Assertions.assertThrows;

import java.io.IOException;

import org.junit.jupiter.api.Test;

/**
 * Tests {@link ClosedWriter}.
 */
class ClosedWriterTest {

    /**
     * Test the {@code flush()} method.
     */
    @Test
    void testFlush() throws IOException {
        try (ClosedWriter cw = new ClosedWriter()) {
            assertThrows(IOException.class, () -> cw.flush());
        }
    }

    /**
     * Test the {@code write(cbuf, off, len)} method.
     */
    @Test
    void testWrite() throws IOException {
        try (ClosedWriter cw = new ClosedWriter()) {
            final char[] cbuf = new char[1];
            assertThrows(IOException.class, () -> cw.write(new char[0], 0, 1));
            // In writers, testing for closed always comes before argument validation
            assertThrows(IOException.class, () -> cw.write(cbuf, -1, 0));
            assertThrows(IOException.class, () -> cw.write(cbuf, 0, -1));
            assertThrows(IOException.class, () -> cw.write(cbuf, 0, 2));
            assertThrows(IOException.class, () -> cw.write((char[]) null, 0, 0));
        }
    }

}
