/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.plist;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.StrictConfigurationComparator;
import org.apache.commons.configuration2.TempDirUtils;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.plist.XMLPropertyListConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestXMLPropertyListConfiguration {
    @TempDir
    public File tempFolder;
    private XMLPropertyListConfiguration config;

    private static void load(XMLPropertyListConfiguration c, File file) throws ConfigurationException {
        new FileHandler((FileBased)c).load(file);
    }

    private void checkArrayProperty(List<?> expectedValues) throws ConfigurationException {
        StringWriter out = new StringWriter();
        new FileHandler((FileBased)this.config).save((Writer)out);
        StringBuilder values = new StringBuilder();
        for (Object v : expectedValues) {
            values.append("<string>").append(v).append("</string>");
        }
        String content = out.toString().replaceAll("[ \n\r]", "");
        Assertions.assertTrue((boolean)content.contains(String.format("<key>array</key><array>%s</array>", values)));
    }

    private void save(File file) throws ConfigurationException {
        new FileHandler((FileBased)this.config).save(file);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.config = new XMLPropertyListConfiguration();
        TestXMLPropertyListConfiguration.load(this.config, ConfigurationAssert.getTestFile("test.plist.xml"));
    }

    @Test
    void testAddArray() throws ConfigurationException {
        Object[] elems = new Object[]{"arrayElem1", "arrayElem2", "arrayElem3"};
        this.config = new XMLPropertyListConfiguration();
        this.config.addProperty("array", (Object)elems);
        this.checkArrayProperty(Arrays.asList(elems));
    }

    @Test
    void testAddDataProperty() throws Exception {
        File savedFile = TempDirUtils.newFile(this.tempFolder);
        byte[] expected = new byte[]{1, 2, 3, 4};
        this.config = new XMLPropertyListConfiguration();
        this.config.addProperty("foo", (Object)expected);
        this.save(savedFile);
        XMLPropertyListConfiguration config2 = new XMLPropertyListConfiguration();
        TestXMLPropertyListConfiguration.load(config2, savedFile);
        Object array = config2.getProperty("foo");
        Assertions.assertNotNull((Object)array);
        Assertions.assertEquals(byte[].class, array.getClass());
        Assertions.assertArrayEquals((byte[])expected, (byte[])((byte[])array));
    }

    @Test
    void testAddList() throws ConfigurationException {
        List<String> elems = Arrays.asList("element1", "element2", "anotherElement");
        this.config = new XMLPropertyListConfiguration();
        this.config.addProperty("array", elems);
        this.checkArrayProperty(elems);
    }

    @Test
    void testArray() {
        Object array = this.config.getProperty("array");
        Assertions.assertInstanceOf(List.class, (Object)array);
        List list = this.config.getList("array");
        Assertions.assertEquals(Arrays.asList("value1", "value2", "value3"), (Object)list);
    }

    @Test
    void testBoolean() throws Exception {
        Assertions.assertTrue((boolean)this.config.getBoolean("boolean1"));
        Assertions.assertFalse((boolean)this.config.getBoolean("boolean2"));
    }

    @Test
    void testDate() throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.set(2005, 0, 1, 12, 0, 0);
        Assertions.assertEquals((Object)calendar.getTime(), (Object)this.config.getProperty("date"));
        calendar.setTimeZone(TimeZone.getTimeZone("CET"));
        calendar.set(2002, 2, 22, 11, 30, 0);
        Assertions.assertEquals((Object)calendar.getTime(), (Object)this.config.getProperty("date-gnustep"));
    }

    @Test
    void testDictionary() {
        Assertions.assertEquals((Object)"value1", (Object)this.config.getProperty("dictionary.key1"));
        Assertions.assertEquals((Object)"value2", (Object)this.config.getProperty("dictionary.key2"));
        Assertions.assertEquals((Object)"value3", (Object)this.config.getProperty("dictionary.key3"));
    }

    @Test
    void testDictionaryArray() {
        String key = "dictionary-array";
        Object array = this.config.getProperty("dictionary-array");
        Assertions.assertNotNull((Object)array);
        Assertions.assertInstanceOf(List.class, (Object)array);
        List list = this.config.getList("dictionary-array");
        Assertions.assertEquals((int)2, (int)list.size());
        Configuration conf1 = (Configuration)Assertions.assertInstanceOf(Configuration.class, list.get(0));
        Assertions.assertFalse((boolean)conf1.isEmpty());
        Assertions.assertEquals((Object)"bar", (Object)conf1.getProperty("foo"));
        Configuration conf2 = (Configuration)Assertions.assertInstanceOf(Configuration.class, list.get(1));
        Assertions.assertFalse((boolean)conf2.isEmpty());
        Assertions.assertEquals((Object)"value", (Object)conf2.getProperty("key"));
    }

    @Test
    void testInitCopy() {
        XMLPropertyListConfiguration copy = new XMLPropertyListConfiguration((HierarchicalConfiguration)this.config);
        StrictConfigurationComparator comp = new StrictConfigurationComparator();
        Assertions.assertTrue((boolean)comp.compare((Configuration)this.config, (Configuration)copy));
    }

    @Test
    void testInteger() throws Exception {
        Assertions.assertEquals((long)12345678900L, (long)this.config.getLong("integer"));
    }

    @Test
    void testLoadNoDict() throws ConfigurationException {
        XMLPropertyListConfiguration plist = new XMLPropertyListConfiguration();
        TestXMLPropertyListConfiguration.load(plist, ConfigurationAssert.getTestFile("test2.plist.xml"));
        Assertions.assertFalse((boolean)plist.isEmpty());
    }

    @Test
    void testLoadNoDictConstr() throws ConfigurationException {
        XMLPropertyListConfiguration plist = new XMLPropertyListConfiguration();
        TestXMLPropertyListConfiguration.load(plist, ConfigurationAssert.getTestFile("test2.plist.xml"));
        Assertions.assertFalse((boolean)plist.isEmpty());
    }

    @Test
    void testNested() {
        Assertions.assertEquals((Object)"value", (Object)this.config.getString("nested.node1.node2.node3"));
    }

    @Test
    void testNestedArray() {
        String key = "nested-array";
        Object array = this.config.getProperty("nested-array");
        Assertions.assertNotNull((Object)array);
        Assertions.assertInstanceOf(List.class, (Object)array);
        List list = this.config.getList("nested-array");
        Assertions.assertEquals((int)2, (int)list.size());
        List list1 = (List)Assertions.assertInstanceOf(List.class, list.get(0));
        Assertions.assertEquals(Arrays.asList("a", "b"), (Object)list1);
        List list2 = (List)Assertions.assertInstanceOf(List.class, list.get(1));
        Assertions.assertEquals(Arrays.asList("c", "d"), (Object)list2);
    }

    @Test
    void testReal() throws Exception {
        Assertions.assertEquals((double)-12.345, (double)this.config.getDouble("real"), (double)0.0);
    }

    @Test
    void testSave() throws Exception {
        File savedFile = TempDirUtils.newFile(this.tempFolder);
        this.save(savedFile);
        Assertions.assertTrue((boolean)savedFile.exists());
        XMLPropertyListConfiguration checkConfig = new XMLPropertyListConfiguration();
        TestXMLPropertyListConfiguration.load(checkConfig, savedFile);
        Iterator it = this.config.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Assertions.assertTrue((boolean)checkConfig.containsKey(key), (String)("The saved configuration doesn't contain the key '" + key + "'"));
            Object value = checkConfig.getProperty(key);
            if (value instanceof byte[]) {
                byte[] array = (byte[])value;
                Assertions.assertArrayEquals((byte[])((byte[])this.config.getProperty(key)), (byte[])array, (String)("Value of the '" + key + "' property"));
                continue;
            }
            if (value instanceof List) {
                List list1 = (List)this.config.getProperty(key);
                List list2 = (List)value;
                Assertions.assertEquals((int)list1.size(), (int)list2.size(), (String)("The size of the list for the key '" + key + "' doesn't match"));
                for (int i = 0; i < list2.size(); ++i) {
                    Object value1 = list1.get(i);
                    Object value2 = list2.get(i);
                    if (value1 instanceof Configuration) {
                        StrictConfigurationComparator comparator = new StrictConfigurationComparator();
                        Assertions.assertTrue((boolean)comparator.compare((Configuration)value1, (Configuration)value2), (String)("The dictionnary at index " + i + " for the key '" + key + "' doesn't match"));
                        continue;
                    }
                    Assertions.assertEquals(value1, value2, (String)("Element at index " + i + " for the key '" + key + "'"));
                }
                Assertions.assertEquals((Object)this.config.getProperty(key), (Object)list1, (String)("Value of the '" + key + "' property"));
                continue;
            }
            Assertions.assertEquals((Object)this.config.getProperty(key), (Object)checkConfig.getProperty(key), (String)("Value of the '" + key + "' property"));
        }
    }

    @Test
    void testSaveEmptyDictionary() throws Exception {
        File savedFile = TempDirUtils.newFile(this.tempFolder);
        this.save(savedFile);
        Assertions.assertTrue((boolean)savedFile.exists());
        XMLPropertyListConfiguration checkConfig = new XMLPropertyListConfiguration();
        TestXMLPropertyListConfiguration.load(checkConfig, savedFile);
        Assertions.assertNull((Object)this.config.getProperty("empty-dictionary"));
        Assertions.assertNull((Object)checkConfig.getProperty("empty-dictionary"));
    }

    @Test
    void testSaveNoEncoding() throws ConfigurationException {
        StringWriter writer = new StringWriter();
        new FileHandler((FileBased)this.config).save((Writer)writer);
        Assertions.assertTrue((boolean)writer.toString().contains("<?xml version=\"1.0\"?>"));
    }

    @Test
    void testSaveWithEncoding() throws ConfigurationException {
        String encoding = StandardCharsets.UTF_8.name();
        FileHandler handler = new FileHandler((FileBased)this.config);
        handler.setEncoding(encoding);
        StringWriter writer = new StringWriter();
        handler.save((Writer)writer);
        Assertions.assertTrue((boolean)writer.toString().contains("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>"));
    }

    @Test
    void testSetArray() throws ConfigurationException {
        Object[] elems = new Object[]{"arrayElem1", "arrayElem2", "arrayElem3"};
        this.config = new XMLPropertyListConfiguration();
        this.config.setProperty("array", (Object)elems);
        this.checkArrayProperty(Arrays.asList(elems));
    }

    @Test
    void testSetDataProperty() throws Exception {
        File savedFile = TempDirUtils.newFile(this.tempFolder);
        byte[] expected = new byte[]{1, 2, 3, 4};
        this.config = new XMLPropertyListConfiguration();
        this.config.setProperty("foo", (Object)expected);
        this.save(savedFile);
        XMLPropertyListConfiguration config2 = new XMLPropertyListConfiguration();
        TestXMLPropertyListConfiguration.load(config2, savedFile);
        Object array = config2.getProperty("foo");
        Assertions.assertNotNull((Object)array);
        Assertions.assertEquals(byte[].class, array.getClass());
        Assertions.assertArrayEquals((byte[])expected, (byte[])((byte[])array));
    }

    @Test
    void testSetDatePropertyInvalid() throws ConfigurationException {
        this.config.clear();
        TestXMLPropertyListConfiguration.load(this.config, ConfigurationAssert.getTestFile("test_invalid_date.plist.xml"));
        Assertions.assertEquals((Object)"value1", (Object)this.config.getString("string"));
        Assertions.assertFalse((boolean)this.config.containsKey("date"));
    }

    @Test
    void testSetList() throws ConfigurationException {
        List<String> elems = Arrays.asList("element1", "element2", "anotherElement");
        this.config = new XMLPropertyListConfiguration();
        this.config.setProperty("array", elems);
        this.checkArrayProperty(elems);
    }

    @Test
    void testString() throws Exception {
        Assertions.assertEquals((Object)"value1", (Object)this.config.getString("string"));
    }

    @Test
    void testSubset() {
        Configuration subset = this.config.subset("dictionary");
        Iterator keys = subset.getKeys();
        String key = (String)keys.next();
        Assertions.assertEquals((Object)"key1", (Object)key);
        Assertions.assertEquals((Object)"value1", (Object)subset.getString(key));
        key = (String)keys.next();
        Assertions.assertEquals((Object)"key2", (Object)key);
        Assertions.assertEquals((Object)"value2", (Object)subset.getString(key));
        key = (String)keys.next();
        Assertions.assertEquals((Object)"key3", (Object)key);
        Assertions.assertEquals((Object)"value3", (Object)subset.getString(key));
        Assertions.assertFalse((boolean)keys.hasNext());
    }

    @Test
    void testWriteCalledDirectly() throws IOException {
        this.config = new XMLPropertyListConfiguration();
        this.config.addProperty("foo", (Object)"bar");
        try (FileWriter out = new FileWriter(TempDirUtils.newFile(this.tempFolder));){
            ConfigurationException e = (ConfigurationException)Assertions.assertThrows(ConfigurationException.class, () -> this.config.write(out));
            Assertions.assertTrue((boolean)e.getMessage().contains("FileHandler"));
        }
    }
}

