/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.pref;

import java.util.Collection;
import java.util.prefs.Preferences;
import org.apache.cayenne.access.DbGenerator;
import org.apache.cayenne.pref.RenamedPreferences;

public class DBGeneratorDefaults
extends RenamedPreferences {
    public static final String CREATE_FK_PROPERTY = "createFK";
    public static final String CREATE_PK_PROPERTY = "createPK";
    public static final String CREATE_TABLES_PROPERTY = "createTables";
    public static final String DROP_PK_PROPERTY = "dropPK";
    public static final String DROP_TABLES_PROPERTY = "dropTables";
    public boolean createFK = this.getCurrentPreference().getBoolean("createFK", true);
    public boolean createPK = this.getCurrentPreference().getBoolean("createPK", true);
    public boolean createTables = this.getCurrentPreference().getBoolean("createTables", true);
    public boolean dropPK = this.getCurrentPreference().getBoolean("dropPK", false);
    public boolean dropTables = this.getCurrentPreference().getBoolean("dropTables", false);

    public DBGeneratorDefaults(Preferences pref) {
        super(pref);
    }

    public void setCreateFK(Boolean createFK) {
        this.createFK = createFK;
        this.getCurrentPreference().putBoolean(CREATE_FK_PROPERTY, createFK);
    }

    public boolean getCreateFK() {
        return this.createFK;
    }

    public void setCreatePK(Boolean createPK) {
        this.createPK = createPK;
        this.getCurrentPreference().putBoolean(CREATE_PK_PROPERTY, createPK);
    }

    public boolean getCreatePK() {
        return this.createPK;
    }

    public void setCreateTables(Boolean createTables) {
        this.createTables = createTables;
        this.getCurrentPreference().putBoolean(CREATE_TABLES_PROPERTY, createTables);
    }

    public boolean getCreateTables() {
        return this.createTables;
    }

    public void setDropPK(Boolean dropPK) {
        this.dropPK = dropPK;
        this.getCurrentPreference().putBoolean(DROP_PK_PROPERTY, dropPK);
    }

    public boolean getDropPK() {
        return this.dropPK;
    }

    public void setDropTables(Boolean dropTables) {
        this.dropTables = dropTables;
        this.getCurrentPreference().putBoolean(DROP_TABLES_PROPERTY, dropTables);
    }

    public boolean getDropTables() {
        return this.dropTables;
    }

    public void configureGenerator(Collection<DbGenerator> generators) {
        this.setCreateFK(this.createFK);
        this.setCreatePK(this.createPK);
        this.setCreateTables(this.createTables);
        this.setDropPK(this.dropPK);
        this.setDropTables(this.dropTables);
        for (DbGenerator generator : generators) {
            generator.setShouldCreateFKConstraints(this.createFK);
            generator.setShouldCreatePKSupport(this.createPK);
            generator.setShouldCreateTables(this.createTables);
            generator.setShouldDropPKSupport(this.dropPK);
            generator.setShouldDropTables(this.dropTables);
        }
    }

    public void prePersist() {
        this.setCreateFK(Boolean.TRUE);
        this.setCreatePK(Boolean.TRUE);
        this.setCreateTables(Boolean.TRUE);
        this.setDropPK(Boolean.FALSE);
        this.setDropTables(Boolean.FALSE);
    }
}

