/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di;

import java.util.List;
import java.util.Map;
import org.apache.cayenne.di.TypeLiteral;

public class Key<T> {
    protected TypeLiteral<T> typeLiteral;
    protected String bindingName;

    public static <T> Key<T> get(Class<T> type) {
        return new Key<T>(TypeLiteral.of(type), null);
    }

    public static <T> Key<T> get(Class<T> type, String bindingName) {
        return new Key<T>(TypeLiteral.of(type), bindingName);
    }

    public static <T> Key<List<T>> getListOf(Class<T> type) {
        return Key.getListOf(type, null);
    }

    public static <T> Key<List<T>> getListOf(Class<T> type, String bindingName) {
        return new Key<List<T>>(TypeLiteral.listOf(type), bindingName);
    }

    public static <K, V> Key<Map<K, V>> getMapOf(Class<K> keyType, Class<V> valueType) {
        return Key.getMapOf(keyType, valueType, null);
    }

    public static <K, V> Key<Map<K, V>> getMapOf(Class<K> keyType, Class<V> valueType, String bindingName) {
        return new Key<Map<K, V>>(TypeLiteral.mapOf(keyType, valueType), bindingName);
    }

    protected Key(TypeLiteral<T> type, String bindingName) {
        if (type == null) {
            throw new NullPointerException("Null key type");
        }
        this.typeLiteral = type;
        this.bindingName = bindingName != null && bindingName.length() > 0 ? bindingName : null;
    }

    public Class<T> getType() {
        return this.typeLiteral.getType();
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Key) {
            Key key = (Key)object;
            if (!this.typeLiteral.equals(key.typeLiteral)) {
                return false;
            }
            if (this.bindingName != null) {
                return this.bindingName.equals(key.bindingName);
            }
            return key.bindingName == null;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 407 + 11 * this.typeLiteral.hashCode();
        if (this.bindingName != null) {
            hashCode += this.bindingName.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<BindingKey: ");
        buffer.append(this.typeLiteral);
        if (this.bindingName != null) {
            buffer.append(", '").append(this.bindingName).append('\'');
        }
        buffer.append('>');
        return buffer.toString();
    }
}

