/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote.hessian.service;

import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.remote.hessian.HessianConfig;
import org.apache.cayenne.rop.ServerHessianSerializationServiceProvider;
import org.apache.cayenne.rop.http.ClientHessianSerializationServiceProvider;

public class HessianUtil {
    public static Object cloneViaClientServerSerialization(Serializable object, EntityResolver serverResolver) throws Exception {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        HessianOutput out = new HessianOutput((OutputStream)bytes);
        out.setSerializerFactory(HessianConfig.createFactory((String[])ClientHessianSerializationServiceProvider.CLIENT_SERIALIZER_FACTORIES, null));
        out.writeObject((Object)object);
        byte[] data = bytes.toByteArray();
        HessianInput in = new HessianInput((InputStream)new ByteArrayInputStream(data));
        in.setSerializerFactory(HessianConfig.createFactory((String[])ServerHessianSerializationServiceProvider.SERVER_SERIALIZER_FACTORIES, (EntityResolver)serverResolver));
        return in.readObject();
    }

    public static Object cloneViaServerClientSerialization(Serializable object, EntityResolver serverResolver) throws Exception {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        HessianOutput out = new HessianOutput((OutputStream)bytes);
        out.setSerializerFactory(HessianConfig.createFactory((String[])ServerHessianSerializationServiceProvider.SERVER_SERIALIZER_FACTORIES, (EntityResolver)serverResolver));
        out.writeObject((Object)object);
        byte[] data = bytes.toByteArray();
        HessianInput in = new HessianInput((InputStream)new ByteArrayInputStream(data));
        in.setSerializerFactory(HessianConfig.createFactory((String[])ClientHessianSerializationServiceProvider.CLIENT_SERIALIZER_FACTORIES, null));
        return in.readObject();
    }

    private HessianUtil() {
    }
}

