/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sqlite;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.cayenne.access.types.UtilDateType;

class SQLiteDateType
extends UtilDateType {
    private final DateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss.SSS");
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private final DateFormat timeFormat = new SimpleDateFormat("kk:mm:ss");

    @Override
    public Date materializeObject(ResultSet rs, int index, int type) throws Exception {
        return this.parseDate(rs.getString(index), type);
    }

    @Override
    public Date materializeObject(CallableStatement rs, int index, int type) throws Exception {
        return this.parseDate(rs.getString(index), type);
    }

    protected Date parseDate(String string, int type) throws SQLException {
        if (string == null) {
            return null;
        }
        long ts = this.getLongTimestamp(string);
        if (ts >= 0L) {
            return new Date(ts);
        }
        switch (type) {
            case 92: {
                return this.getTime(string);
            }
        }
        return this.getTimestamp(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date getTimestamp(String string) throws SQLException {
        try {
            DateFormat dateFormat = this.timestampFormat;
            synchronized (dateFormat) {
                return this.timestampFormat.parse(string);
            }
        }
        catch (ParseException e) {
            return this.getDate(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date getDate(String string) throws SQLException {
        try {
            DateFormat dateFormat = this.dateFormat;
            synchronized (dateFormat) {
                return this.dateFormat.parse(string);
            }
        }
        catch (ParseException e) {
            throw new SQLException("Unparsable date/time string: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date getTime(String string) throws SQLException {
        try {
            DateFormat dateFormat = this.timeFormat;
            synchronized (dateFormat) {
                return this.timeFormat.parse(string);
            }
        }
        catch (ParseException e) {
            return this.getTimestamp(string);
        }
    }

    protected long getLongTimestamp(String string) {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }
}

