/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush;

import java.util.Objects;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.graph.ArcId;

class ArcTarget {
    private final ObjectId sourceId;
    private final ObjectId targetId;
    private final ArcId arcId;
    private final boolean delete;

    ArcTarget(ObjectId sourceId, ObjectId targetId, ArcId arcId, boolean delete) {
        this.sourceId = Objects.requireNonNull(sourceId);
        this.targetId = Objects.requireNonNull(targetId);
        this.arcId = Objects.requireNonNull(arcId);
        this.delete = delete;
    }

    ArcTarget getReversed() {
        return new ArcTarget(this.targetId, this.sourceId, this.arcId.getReverseId(), this.delete);
    }

    ArcId getArcId() {
        return this.arcId;
    }

    ObjectId getSourceId() {
        return this.sourceId;
    }

    ObjectId getTargetId() {
        return this.targetId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArcTarget arcTarget = (ArcTarget)o;
        if (this.delete != arcTarget.delete) {
            return false;
        }
        if (!this.sourceId.equals(arcTarget.sourceId)) {
            return false;
        }
        if (!this.targetId.equals(arcTarget.targetId)) {
            return false;
        }
        return this.arcId.equals(arcTarget.arcId);
    }

    public int hashCode() {
        int result = this.sourceId.hashCode();
        result = 31 * result + this.targetId.hashCode();
        result = 31 * result + this.arcId.hashCode();
        result = 31 * result + (this.delete ? 1 : 0);
        return result;
    }
}

