/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.graph.ArcId;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.GraphManager;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.reflect.LifecycleCallbackRegistry;

public abstract class DataChannelSyncCallbackAction
implements GraphChangeHandler {
    LifecycleCallbackRegistry callbackRegistry;
    Collection<Object> updated;
    Collection<Object> persisted;
    Collection<Object> removed;
    private Map<Object, Op> seenIds;
    private GraphManager graphManager;

    public static DataChannelSyncCallbackAction getCallbackAction(LifecycleCallbackRegistry callbackRegistry, GraphManager graphManager, GraphDiff changes, int syncType) {
        switch (syncType) {
            case 1: 
            case 2: {
                return new FlushCallbackAction(callbackRegistry, graphManager, changes);
            }
            case 3: {
                return new RollbackCallbackAction(callbackRegistry, graphManager, changes);
            }
        }
        throw new IllegalArgumentException("Unsupported sync type: " + syncType);
    }

    DataChannelSyncCallbackAction(LifecycleCallbackRegistry callbackRegistry, GraphManager graphManager, GraphDiff changes) {
        this.callbackRegistry = callbackRegistry;
        this.graphManager = graphManager;
        if (this.hasListeners()) {
            this.seenIds = new HashMap<Object, Op>();
            changes.apply(this);
        }
    }

    protected abstract boolean hasListeners();

    public abstract void applyPreCommit();

    public abstract void applyPostCommit();

    void apply(LifecycleEvent callbackType, Collection<?> objects) {
        if (this.seenIds != null && objects != null) {
            this.callbackRegistry.performCallbacks(callbackType, objects);
        }
    }

    @Override
    public void nodeCreated(Object nodeId) {
        Object node;
        Op op = this.seenIds.put(nodeId, Op.INSERT);
        if (op == null && (node = this.graphManager.getNode(nodeId)) != null) {
            if (this.persisted == null) {
                this.persisted = new ArrayList<Object>();
            }
            this.persisted.add(node);
        }
    }

    @Override
    public void nodeRemoved(Object nodeId) {
        Object node;
        Op op = this.seenIds.put(nodeId, Op.DELETE);
        if (op != Op.DELETE && (node = this.graphManager.getNode(nodeId)) != null) {
            if (this.removed == null) {
                this.removed = new ArrayList<Object>();
            }
            this.removed.add(node);
            if (op == Op.UPDATE) {
                this.updated.remove(node);
            }
        }
    }

    @Override
    public void arcCreated(Object nodeId, Object targetNodeId, ArcId arcId) {
        this.nodeUpdated(nodeId);
    }

    @Override
    public void arcDeleted(Object nodeId, Object targetNodeId, ArcId arcId) {
        this.nodeUpdated(nodeId);
    }

    @Override
    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        this.nodeUpdated(nodeId);
    }

    private void nodeUpdated(Object nodeId) {
        Object node;
        Op op = this.seenIds.put(nodeId, Op.UPDATE);
        if (op == null && (node = this.graphManager.getNode(nodeId)) != null) {
            if (this.updated == null) {
                this.updated = new ArrayList<Object>();
            }
            this.updated.add(node);
        }
    }

    static class FlushCallbackAction
    extends DataChannelSyncCallbackAction {
        FlushCallbackAction(LifecycleCallbackRegistry callbackRegistry, GraphManager graphManager, GraphDiff changes) {
            super(callbackRegistry, graphManager, changes);
        }

        @Override
        protected boolean hasListeners() {
            return !this.callbackRegistry.isEmpty(LifecycleEvent.PRE_UPDATE) || !this.callbackRegistry.isEmpty(LifecycleEvent.PRE_PERSIST) || !this.callbackRegistry.isEmpty(LifecycleEvent.POST_UPDATE) || !this.callbackRegistry.isEmpty(LifecycleEvent.POST_REMOVE) || !this.callbackRegistry.isEmpty(LifecycleEvent.POST_PERSIST);
        }

        @Override
        public void applyPreCommit() {
            this.apply(LifecycleEvent.PRE_PERSIST, this.persisted);
            this.apply(LifecycleEvent.PRE_UPDATE, this.updated);
        }

        @Override
        public void applyPostCommit() {
            this.apply(LifecycleEvent.POST_UPDATE, this.updated);
            this.apply(LifecycleEvent.POST_REMOVE, this.removed);
            this.apply(LifecycleEvent.POST_PERSIST, this.persisted);
        }
    }

    static class RollbackCallbackAction
    extends DataChannelSyncCallbackAction {
        RollbackCallbackAction(LifecycleCallbackRegistry callbackRegistry, GraphManager graphManager, GraphDiff changes) {
            super(callbackRegistry, graphManager, changes);
        }

        @Override
        protected boolean hasListeners() {
            return !this.callbackRegistry.isEmpty(LifecycleEvent.POST_LOAD);
        }

        @Override
        public void applyPreCommit() {
        }

        @Override
        public void applyPostCommit() {
            this.apply(LifecycleEvent.POST_LOAD, this.updated);
            this.apply(LifecycleEvent.POST_LOAD, this.removed);
        }
    }

    static enum Op {
        INSERT,
        UPDATE,
        DELETE;

    }
}

