/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.bridge;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.cassandra.bridge.TokenRange;
import org.apache.cassandra.cdc.api.CassandraSource;
import org.apache.cassandra.cdc.api.CommitLog;
import org.apache.cassandra.cdc.api.CommitLogInstance;
import org.apache.cassandra.cdc.api.CommitLogMarkers;
import org.apache.cassandra.cdc.api.CommitLogReader;
import org.apache.cassandra.cdc.api.Marker;
import org.apache.cassandra.cdc.api.Row;
import org.apache.cassandra.cdc.api.TableIdLookup;
import org.apache.cassandra.cdc.scanner.CdcStreamScanner;
import org.apache.cassandra.cdc.state.CdcState;
import org.apache.cassandra.cdc.stats.ICdcStats;
import org.apache.cassandra.db.commitlog.PartitionUpdateWrapper;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.utils.AsyncExecutor;
import org.apache.cassandra.spark.utils.TimeProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CdcBridge {
    public static final Object UNSET_MARKER = new Object();
    public static final String IMPLEMENTATION_FQCN = "org.apache.cassandra.bridge.CdcBridgeImplementation";
    public static final String CONVERTER_IMPLEMENTATION_FQCN = "org.apache.cassandra.cdc.avro.CqlToAvroSchemaConverterImplementation";

    public void log(CqlTable cqlTable, CommitLogInstance log, Row row, long timestamp) {
        this.log(TimeProvider.DEFAULT, cqlTable, log, row, timestamp);
    }

    public abstract void updateCdcSchema(@NotNull Set<CqlTable> var1, @NotNull Partitioner var2, @NotNull TableIdLookup var3);

    public abstract CommitLogReader.Result readLog(@NotNull CommitLog var1, @Nullable TokenRange var2, @NotNull CommitLogMarkers var3, int var4, @NotNull ICdcStats var5, @Nullable AsyncExecutor var6, @Nullable Consumer<Marker> var7, @Nullable Long var8, boolean var9);

    public abstract CdcStreamScanner openCdcStreamScanner(Collection<PartitionUpdateWrapper> var1, @NotNull CdcState var2, Random var3, CassandraSource var4, double var5);

    @VisibleForTesting
    public abstract void log(TimeProvider var1, CqlTable var2, CommitLogInstance var3, Row var4, long var5);
}

