/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import o.a.c.sidecar.client.shaded.client.SidecarClient;
import o.a.c.sidecar.client.shaded.client.SidecarInstance;
import o.a.c.sidecar.client.shaded.client.SidecarInstanceImpl;
import o.a.c.sidecar.client.shaded.common.response.ListSnapshotFilesResponse;
import org.apache.cassandra.analytics.stats.Stats;
import org.apache.cassandra.clients.Sidecar;
import org.apache.cassandra.spark.data.FileType;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.data.SidecarProvisionedSSTable;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

class SidecarProvisionedSSTableTest {
    SidecarClient mockSidecarClient;
    private Sidecar.ClientConfig sidecarClientConfig;

    SidecarProvisionedSSTableTest() {
    }

    @BeforeEach
    void setup() {
        this.mockSidecarClient = (SidecarClient)Mockito.mock(SidecarClient.class);
        this.sidecarClientConfig = Sidecar.ClientConfig.create();
    }

    @Test
    void testEqualityAndHashCode() {
        SSTable ssTable10 = this.prepareTable("localhost1", 9043, "keyspace1", "table1", "snapshot1", "na-1-big-Data.db");
        SSTable ssTable20 = this.prepareTable("localhost1", 9043, "keyspace2", "table1", "snapshot1", "na-1-big-Data.db");
        SSTable ssTable30 = this.prepareTable("localhost1", 9043, "keyspace1", "table2", "snapshot1", "na-1-big-Data.db");
        SSTable ssTable40 = this.prepareTable("localhost2", 9043, "keyspace1", "table2", "snapshot1", "na-1-big-Data.db");
        SSTable ssTable50 = this.prepareTable("localhost1", 9044, "keyspace1", "table2", "snapshot1", "na-1-big-Data.db");
        SSTable ssTable60 = this.prepareTable("localhost1", 9043, "keyspace1", "table1", "snapshot1", "na-2-big-Data.db");
        SSTable ssTable11 = this.prepareTable("localhost1", 9043, "keyspace1", "table1", "snapshot1", "na-1-big-Data.db");
        SSTable ssTable21 = this.prepareTable("localhost1", 9043, "keyspace2", "table1", "snapshot1", "na-1-big-Data.db");
        SSTable ssTable31 = this.prepareTable("localhost1", 9043, "keyspace1", "table2", "snapshot1", "na-1-big-Data.db");
        SSTable ssTable41 = this.prepareTable("localhost2", 9043, "keyspace1", "table2", "snapshot1", "na-1-big-Data.db");
        SSTable ssTable51 = this.prepareTable("localhost1", 9044, "keyspace1", "table2", "snapshot1", "na-1-big-Data.db");
        SSTable ssTable61 = this.prepareTable("localhost1", 9043, "keyspace1", "table1", "snapshot1", "na-2-big-Data.db");
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)ssTable10).isNotEqualTo((Object)ssTable20)).isNotEqualTo((Object)ssTable30)).isNotEqualTo((Object)ssTable40)).isNotEqualTo((Object)ssTable50)).isNotEqualTo((Object)ssTable60);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)ssTable20).isNotEqualTo((Object)ssTable30)).isNotEqualTo((Object)ssTable40)).isNotEqualTo((Object)ssTable50)).isNotEqualTo((Object)ssTable60);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)ssTable30).isNotEqualTo((Object)ssTable40)).isNotEqualTo((Object)ssTable50)).isNotEqualTo((Object)ssTable60);
        ((ObjectAssert)Assertions.assertThat((Object)ssTable40).isNotEqualTo((Object)ssTable50)).isNotEqualTo((Object)ssTable60);
        Assertions.assertThat((Object)ssTable50).isNotEqualTo((Object)ssTable60);
        Assertions.assertThat((Object)ssTable10).isEqualTo((Object)ssTable11);
        Assertions.assertThat((Object)ssTable20).isEqualTo((Object)ssTable21);
        Assertions.assertThat((Object)ssTable30).isEqualTo((Object)ssTable31);
        Assertions.assertThat((Object)ssTable40).isEqualTo((Object)ssTable41);
        Assertions.assertThat((Object)ssTable50).isEqualTo((Object)ssTable51);
        Assertions.assertThat((Object)ssTable60).isEqualTo((Object)ssTable61);
    }

    @Test
    void testToString() {
        SSTable ssTable10 = this.prepareTable("localhost1", 9043, "keyspace1", "table1", "snapshot1", "na-1-big-Data.db");
        SSTable ssTable20 = this.prepareTable("localhost1", 9043, "keyspace2", "table1", "snapshot1", "na-1-big-Data.db");
        SSTable ssTable30 = this.prepareTable("localhost1", 9043, "keyspace1", "table2", "snapshot1", "na-1-big-Data.db");
        SSTable ssTable40 = this.prepareTable("localhost2", 9043, "keyspace1", "table2", "snapshot1", "na-1-big-Data.db");
        SSTable ssTable50 = this.prepareTable("localhost1", 9044, "keyspace1", "table2", "snapshot1", "na-1-big-Data.db");
        SSTable ssTable60 = this.prepareTable("localhost1", 9043, "keyspace1", "table1", "snapshot1", "na-2-big-Data.db");
        Assertions.assertThat((String)ssTable10.toString()).isEqualTo("SidecarProvisionedSSTable{hostname='localhost1', port=9043, keyspace='keyspace1', table='table1', snapshotName='snapshot1', dataFileName='na-1-big-Data.db', partitionId=1}");
        Assertions.assertThat((String)ssTable20.toString()).isEqualTo("SidecarProvisionedSSTable{hostname='localhost1', port=9043, keyspace='keyspace2', table='table1', snapshotName='snapshot1', dataFileName='na-1-big-Data.db', partitionId=1}");
        Assertions.assertThat((String)ssTable30.toString()).isEqualTo("SidecarProvisionedSSTable{hostname='localhost1', port=9043, keyspace='keyspace1', table='table2', snapshotName='snapshot1', dataFileName='na-1-big-Data.db', partitionId=1}");
        Assertions.assertThat((String)ssTable40.toString()).isEqualTo("SidecarProvisionedSSTable{hostname='localhost2', port=9043, keyspace='keyspace1', table='table2', snapshotName='snapshot1', dataFileName='na-1-big-Data.db', partitionId=1}");
        Assertions.assertThat((String)ssTable50.toString()).isEqualTo("SidecarProvisionedSSTable{hostname='localhost1', port=9044, keyspace='keyspace1', table='table2', snapshotName='snapshot1', dataFileName='na-1-big-Data.db', partitionId=1}");
        Assertions.assertThat((String)ssTable60.toString()).isEqualTo("SidecarProvisionedSSTable{hostname='localhost1', port=9043, keyspace='keyspace1', table='table1', snapshotName='snapshot1', dataFileName='na-2-big-Data.db', partitionId=1}");
    }

    @ParameterizedTest
    @ValueSource(strings={"bad1bigData.db", "na-1-big.db"})
    void failsOnBadDataFileName(String dataFileName) {
        Assertions.assertThatExceptionOfType(ArrayIndexOutOfBoundsException.class).isThrownBy(() -> this.prepareTable("localhost", 9043, "ks", "tbl", "snap", dataFileName));
    }

    SSTable prepareTable(String sidecarHostName, int sidecarPort, String keyspace, String table, String snapshot, String dataFileName) {
        return this.prepareTable(this.sidecarClientConfig, sidecarHostName, sidecarPort, keyspace, table, snapshot, dataFileName, 5);
    }

    SSTable prepareTable(Sidecar.ClientConfig clientConfig, String sidecarHostName, int sidecarPort, String keyspace, String table, String snapshot, String dataFileName, int compressionFileSize) {
        ListSnapshotFilesResponse.FileInfo fileInfo = new ListSnapshotFilesResponse.FileInfo(5L, sidecarHostName, sidecarPort, 1, snapshot, keyspace, table + "-abc1234", dataFileName);
        ListSnapshotFilesResponse.FileInfo compressionInfo = new ListSnapshotFilesResponse.FileInfo((long)compressionFileSize, sidecarHostName, sidecarPort, 1, snapshot, keyspace, table + "-abc1234", dataFileName);
        return new SidecarProvisionedSSTable(this.mockSidecarClient, clientConfig, (SidecarInstance)new SidecarInstanceImpl(sidecarHostName, sidecarPort), keyspace, table, snapshot, (Map)ImmutableMap.of((Object)FileType.DATA, (Object)fileInfo, (Object)FileType.COMPRESSION_INFO, (Object)compressionInfo), 1, (Stats)Stats.DoNothingStats.INSTANCE);
    }
}

