/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Stream;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.spark.data.LocalDataLayer;
import org.apache.cassandra.spark.data.SSTablesSupplier;
import org.apache.cassandra.spark.data.VersionRunner;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.utils.ByteBufferUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class LocalDataLayerTests
extends VersionRunner {
    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testLocalDataLayer(CassandraBridge bridge) throws IOException {
        CassandraVersion version = bridge.getVersion();
        Path directory1 = Files.createTempDirectory("d1", new FileAttribute[0]);
        Path directory2 = Files.createTempDirectory("d2", new FileAttribute[0]);
        Path directory3 = Files.createTempDirectory("d3", new FileAttribute[0]);
        Path directory4 = Files.createTempDirectory("d4", new FileAttribute[0]);
        LocalDataLayer dataLayer = new LocalDataLayer(version, "backup_test", "CREATE TABLE backup_test.sbr_test (\n    account_id uuid,\n    balance bigint,\n    name text,\n    PRIMARY KEY(account_id)\n) WITH bloom_filter_fp_chance = 0.1\n    AND caching = {'keys': 'ALL', 'rows_per_partition': 'NONE'}\n    AND comment = 'Created by: jberragan'\n    AND compaction = {'class': 'org.apache.cassandra.db.compaction.LeveledCompactionStrategy'}\n    AND compression = {'chunk_length_in_kb': '64', 'class': 'org.apache.cassandra.io.compress.LZ4Compressor'}\n    AND crc_check_chance = 1.0\n    AND default_time_to_live = 0\n    AND gc_grace_seconds = 864000\n    AND max_index_interval = 2048\n    AND memtable_flush_period_in_ms = 0\n    AND min_index_interval = 128\n;", (String[])Stream.of(directory1, directory2, directory3, directory4).map(directory -> directory.toAbsolutePath().toString()).toArray(String[]::new));
        Assertions.assertThat((Comparable)dataLayer.version()).isEqualTo((Object)version);
        Assertions.assertThat((int)dataLayer.partitionCount()).isEqualTo(1);
        Assertions.assertThat((Object)dataLayer.cqlTable()).isNotNull();
        Assertions.assertThat((boolean)dataLayer.isInPartition(0, BigInteger.ZERO, ByteBuffer.wrap(ByteBufferUtils.EMPTY))).isTrue();
        Assertions.assertThat((Comparable)dataLayer.partitioner()).isEqualTo((Object)Partitioner.Murmur3Partitioner);
        SSTablesSupplier ssTables = dataLayer.sstables(0, null, Collections.emptyList());
        Assertions.assertThat((Object)ssTables).isNotNull();
        Assertions.assertThat((boolean)ssTables.openAll((ssTable, isRepairPrimary) -> null).isEmpty()).isTrue();
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testEquality(CassandraBridge bridge) {
        CassandraVersion version = bridge.getVersion();
        LocalDataLayer dataLayer1 = new LocalDataLayer(version, "backup_test", "CREATE TABLE backup_test.sbr_test (\n    account_id uuid,\n    balance bigint,\n    name text,\n    PRIMARY KEY(account_id)\n) WITH bloom_filter_fp_chance = 0.1\n    AND caching = {'keys': 'ALL', 'rows_per_partition': 'NONE'}\n    AND comment = 'Created by: jberragan'\n    AND compaction = {'class': 'org.apache.cassandra.db.compaction.LeveledCompactionStrategy'}\n    AND compression = {'chunk_length_in_kb': '64', 'class': 'org.apache.cassandra.io.compress.LZ4Compressor'}\n    AND crc_check_chance = 1.0\n    AND default_time_to_live = 0\n    AND gc_grace_seconds = 864000\n    AND max_index_interval = 2048\n    AND memtable_flush_period_in_ms = 0\n    AND min_index_interval = 128\n;", new String[]{"/var/lib/cassandra/data1/data/backup_test/sbr_test/snapshot/snapshotName/", "/var/lib/cassandra/data2/data/backup_test/sbr_test/snapshot/snapshotName/", "/var/lib/cassandra/data3/data/backup_test/sbr_test/snapshot/snapshotName/", "/var/lib/cassandra/data4/data/backup_test/sbr_test/snapshot/snapshotName/"});
        LocalDataLayer dataLayer2 = new LocalDataLayer(version, "backup_test", "CREATE TABLE backup_test.sbr_test (\n    account_id uuid,\n    balance bigint,\n    name text,\n    PRIMARY KEY(account_id)\n) WITH bloom_filter_fp_chance = 0.1\n    AND caching = {'keys': 'ALL', 'rows_per_partition': 'NONE'}\n    AND comment = 'Created by: jberragan'\n    AND compaction = {'class': 'org.apache.cassandra.db.compaction.LeveledCompactionStrategy'}\n    AND compression = {'chunk_length_in_kb': '64', 'class': 'org.apache.cassandra.io.compress.LZ4Compressor'}\n    AND crc_check_chance = 1.0\n    AND default_time_to_live = 0\n    AND gc_grace_seconds = 864000\n    AND max_index_interval = 2048\n    AND memtable_flush_period_in_ms = 0\n    AND min_index_interval = 128\n;", new String[]{"/var/lib/cassandra/data1/data/backup_test/sbr_test/snapshot/snapshotName/", "/var/lib/cassandra/data2/data/backup_test/sbr_test/snapshot/snapshotName/", "/var/lib/cassandra/data3/data/backup_test/sbr_test/snapshot/snapshotName/", "/var/lib/cassandra/data4/data/backup_test/sbr_test/snapshot/snapshotName/"});
        Assertions.assertThat((Object)dataLayer2).isNotSameAs((Object)dataLayer1);
        Assertions.assertThat((Object)dataLayer1).isEqualTo((Object)dataLayer1);
        Assertions.assertThat((Object)dataLayer2).isEqualTo((Object)dataLayer2);
        Assertions.assertThat((Object)dataLayer2).isNotEqualTo(null);
        Assertions.assertThat((Object)dataLayer1).isNotEqualTo(new ArrayList());
        Assertions.assertThat((Object)dataLayer2).isEqualTo((Object)dataLayer1);
        Assertions.assertThat((int)dataLayer2.hashCode()).isEqualTo(dataLayer1.hashCode());
    }
}

