/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.spark.TestDataLayer;
import org.apache.cassandra.spark.TestUtils;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.FileType;
import org.apache.cassandra.spark.utils.test.TestSchema;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataLayerUnsupportedPushDownFiltersTest {
    @Test
    public void testNoFilters() {
        TestUtils.runTest((partitioner, directory, bridge) -> {
            TestSchema schema = TestSchema.basic((CassandraBridge)bridge);
            List<Path> dataFiles = TestUtils.getFileType(directory, FileType.DATA).collect(Collectors.toList());
            TestDataLayer dataLayer = new TestDataLayer(bridge, dataFiles, schema.buildTable());
            Object[] unsupportedFilters = dataLayer.unsupportedPushDownFilters(new Filter[0]);
            Assertions.assertThat((Object[])unsupportedFilters).isNotNull();
            Assertions.assertThat((Object[])unsupportedFilters).hasSize(0);
        });
    }

    @Test
    public void testSupportedEqualToFilter() {
        TestUtils.runTest((partitioner, directory, bridge) -> {
            TestSchema schema = TestSchema.basic((CassandraBridge)bridge);
            List<Path> dataFiles = TestUtils.getFileType(directory, FileType.DATA).collect(Collectors.toList());
            TestDataLayer dataLayer = new TestDataLayer(bridge, dataFiles, schema.buildTable());
            Filter[] allFilters = new Filter[]{new EqualTo("a", (Object)5)};
            Object[] unsupportedFilters = dataLayer.unsupportedPushDownFilters(allFilters);
            Assertions.assertThat((Object[])unsupportedFilters).isNotNull();
            Assertions.assertThat((Object[])unsupportedFilters).hasSize(0);
        });
    }

    @Test
    public void testSupportedFilterCaseInsensitive() {
        TestUtils.runTest((partitioner, directory, bridge) -> {
            TestSchema schema = TestSchema.basic((CassandraBridge)bridge);
            List<Path> dataFiles = TestUtils.getFileType(directory, FileType.DATA).collect(Collectors.toList());
            TestDataLayer dataLayer = new TestDataLayer(bridge, dataFiles, schema.buildTable());
            Filter[] allFilters = new Filter[]{new EqualTo("A", (Object)5)};
            Object[] unsupportedFilters = dataLayer.unsupportedPushDownFilters(allFilters);
            Assertions.assertThat((Object[])unsupportedFilters).isNotNull();
            Assertions.assertThat((Object[])unsupportedFilters).hasSize(0);
        });
    }

    @Test
    public void testSupportedInFilter() {
        TestUtils.runTest((partitioner, directory, bridge) -> {
            TestSchema schema = TestSchema.basic((CassandraBridge)bridge);
            List<Path> dataFiles = TestUtils.getFileType(directory, FileType.DATA).collect(Collectors.toList());
            TestDataLayer dataLayer = new TestDataLayer(bridge, dataFiles, schema.buildTable());
            Filter[] allFilters = new Filter[]{new In("a", new Object[]{5, 6, 7})};
            Object[] unsupportedFilters = dataLayer.unsupportedPushDownFilters(allFilters);
            Assertions.assertThat((Object[])unsupportedFilters).isNotNull();
            Assertions.assertThat((Object[])unsupportedFilters).hasSize(0);
        });
    }

    @Test
    public void testSupportedEqualFilterWithClusteringKey() {
        TestUtils.runTest((partitioner, directory, bridge) -> {
            TestSchema schema = TestSchema.basic((CassandraBridge)bridge);
            List<Path> dataFiles = TestUtils.getFileType(directory, FileType.DATA).collect(Collectors.toList());
            TestDataLayer dataLayer = new TestDataLayer(bridge, dataFiles, schema.buildTable());
            Filter[] allFilters = new Filter[]{new EqualTo("a", (Object)5), new EqualTo("b", (Object)8)};
            Object[] unsupportedFilters = dataLayer.unsupportedPushDownFilters(allFilters);
            Assertions.assertThat((Object[])unsupportedFilters).isNotNull();
            Assertions.assertThat((Object[])unsupportedFilters).hasSize(1);
        });
    }

    @Test
    public void testUnsupportedEqualFilterWithColumn() {
        TestUtils.runTest((partitioner, directory, bridge) -> {
            TestSchema schema = TestSchema.basic((CassandraBridge)bridge);
            List<Path> dataFiles = TestUtils.getFileType(directory, FileType.DATA).collect(Collectors.toList());
            TestDataLayer dataLayer = new TestDataLayer(bridge, dataFiles, schema.buildTable());
            EqualTo unsupportedNonPartitionKeyColumnFilter = new EqualTo("c", (Object)25);
            Filter[] allFilters = new Filter[]{new EqualTo("a", (Object)5), unsupportedNonPartitionKeyColumnFilter};
            Object[] unsupportedFilters = dataLayer.unsupportedPushDownFilters(allFilters);
            Assertions.assertThat((Object[])unsupportedFilters).isNotNull();
            Assertions.assertThat((Object[])unsupportedFilters).hasSize(1);
            Assertions.assertThat((Object)unsupportedFilters[0]).isSameAs((Object)unsupportedNonPartitionKeyColumnFilter);
        });
    }

    @Test
    public void testUnsupportedFilters() {
        TestUtils.runTest((partitioner, directory, bridge) -> {
            TestSchema schema = TestSchema.basic((CassandraBridge)bridge);
            List<Path> dataFiles = TestUtils.getFileType(directory, FileType.DATA).collect(Collectors.toList());
            TestDataLayer dataLayer = new TestDataLayer(bridge, dataFiles, schema.buildTable());
            ImmutableList unsupportedFilterList = ImmutableList.of((Object)new EqualNullSafe("a", (Object)5), (Object)new GreaterThan("a", (Object)5), (Object)new GreaterThanOrEqual("a", (Object)5), (Object)new LessThan("a", (Object)5), (Object)new LessThanOrEqual("a", (Object)5), (Object)new IsNull("a"), (Object)new IsNotNull("a"), (Object)new And((Filter)new EqualTo("a", (Object)5), (Filter)new EqualTo("b", (Object)6)), (Object)new Or((Filter)new EqualTo("a", (Object)5), (Filter)new EqualTo("b", (Object)6)), (Object)new Not((Filter)new In("a", new Object[]{5, 6, 7})), (Object)new StringStartsWith("a", "abc"), (Object)new StringEndsWith("a", "abc"), (Object[])new Filter[]{new StringContains("a", "abc")});
            for (Filter unsupportedFilter : unsupportedFilterList) {
                Filter[] allFilters = new Filter[]{unsupportedFilter};
                Object[] unsupportedFilters = dataLayer.unsupportedPushDownFilters(allFilters);
                Assertions.assertThat((Object[])unsupportedFilters).isNotNull();
                Assertions.assertThat((Object[])unsupportedFilters).hasSize(1);
            }
        });
    }

    @Test
    public void testSchemaWithCompositePartitionKey() {
        TestUtils.runTest((partitioner, directory, bridge) -> {
            TestSchema schema = this.schemaWithCompositePartitionKey(bridge);
            List<Path> dataFiles = TestUtils.getFileType(directory, FileType.DATA).collect(Collectors.toList());
            TestDataLayer dataLayer = new TestDataLayer(bridge, dataFiles, schema.buildTable());
            Filter[] allFilters = new Filter[]{new EqualTo("a", (Object)5)};
            Object[] unsupportedFilters = dataLayer.unsupportedPushDownFilters(allFilters);
            Assertions.assertThat((Object[])unsupportedFilters).isNotNull();
            Assertions.assertThat((Object[])unsupportedFilters).hasSize(1);
            allFilters = new Filter[]{new EqualTo("a", (Object)5), new EqualTo("b", (Object)10)};
            unsupportedFilters = dataLayer.unsupportedPushDownFilters(allFilters);
            Assertions.assertThat((Object[])unsupportedFilters).isNotNull();
            Assertions.assertThat((Object[])unsupportedFilters).hasSize(2);
            allFilters = new Filter[]{new EqualTo("a", (Object)5), new EqualTo("b", (Object)10), new EqualTo("d", (Object)20)};
            unsupportedFilters = dataLayer.unsupportedPushDownFilters(allFilters);
            Assertions.assertThat((Object[])unsupportedFilters).isNotNull();
            Assertions.assertThat((Object[])unsupportedFilters).hasSize(3);
            allFilters = new Filter[]{new EqualTo("a", (Object)5), new EqualTo("b", (Object)10), new EqualTo("c", (Object)15)};
            unsupportedFilters = dataLayer.unsupportedPushDownFilters(allFilters);
            Assertions.assertThat((Object[])unsupportedFilters).isNotNull();
            Assertions.assertThat((Object[])unsupportedFilters).isEmpty();
        });
    }

    @Test
    public void testDisablePushDownWhenPartitionKeyIsMissing() {
        TestUtils.runTest((partitioner, directory, bridge) -> {
            TestSchema schema = TestSchema.basic((CassandraBridge)bridge);
            List<Path> dataFiles = TestUtils.getFileType(directory, FileType.DATA).collect(Collectors.toList());
            TestDataLayer dataLayer = new TestDataLayer(bridge, dataFiles, schema.buildTable());
            Filter[] allFilters = new Filter[]{new EqualTo("b", (Object)25)};
            Object[] unsupportedFilters = dataLayer.unsupportedPushDownFilters(allFilters);
            Assertions.assertThat((Object[])unsupportedFilters).isNotNull();
            Assertions.assertThat((Object[])unsupportedFilters).hasSize(1);
        });
    }

    private TestSchema schemaWithCompositePartitionKey(CassandraBridge bridge) {
        return TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.aInt()).withPartitionKey("b", (CqlField.CqlType)bridge.aInt()).withPartitionKey("c", (CqlField.CqlType)bridge.aInt()).withClusteringKey("d", (CqlField.CqlType)bridge.aInt()).withColumn("e", (CqlField.CqlType)bridge.aInt()).build();
    }
}

