/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.cassandra.spark.bulkwriter.BulkSparkConf;
import org.apache.cassandra.spark.bulkwriter.CassandraJobInfo;
import org.apache.cassandra.spark.bulkwriter.TokenPartitioner;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.MultiClusterContainer;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class CassandraJobInfoTest {
    private static final String CLUSTER_1 = "cluster1";
    private static final String CLUSTER_2 = "cluster2";
    private final UUID cluster1JobId = UUID.randomUUID();
    private final UUID cluster2JobId = UUID.randomUUID();

    CassandraJobInfoTest() {
    }

    @Test
    void testGetRestoreJobIdInSingleClusterScenario() {
        MultiClusterContainer restoreJobIds = MultiClusterContainer.ofSingle((Object)this.cluster1JobId);
        CassandraJobInfo jobInfo = this.createJobInfo((MultiClusterContainer<UUID>)restoreJobIds);
        Assertions.assertThat((Comparable)jobInfo.getRestoreJobId()).isEqualTo((Object)this.cluster1JobId);
        Assertions.assertThat((Comparable)jobInfo.getRestoreJobId(null)).isEqualTo((Object)this.cluster1JobId);
    }

    @Test
    void testGetRestoreJobIdWithClusterIdReturnsCorrectUuidForSpecificCluster() {
        MultiClusterContainer restoreJobIds = new MultiClusterContainer();
        restoreJobIds.setValue(CLUSTER_1, (Object)this.cluster1JobId);
        restoreJobIds.setValue(CLUSTER_2, (Object)this.cluster2JobId);
        CassandraJobInfo jobInfo = this.createJobInfo((MultiClusterContainer<UUID>)restoreJobIds);
        Assertions.assertThat((Comparable)jobInfo.getRestoreJobId(CLUSTER_1)).isEqualTo((Object)this.cluster1JobId);
        Assertions.assertThat((Comparable)jobInfo.getRestoreJobId(CLUSTER_2)).isEqualTo((Object)this.cluster2JobId);
    }

    @Test
    void testGetRestoreJobIdThrowsNoSuchElement() {
        MultiClusterContainer restoreJobIds = new MultiClusterContainer();
        restoreJobIds.setValue(CLUSTER_1, (Object)this.cluster1JobId);
        restoreJobIds.setValue(CLUSTER_2, (Object)this.cluster2JobId);
        CassandraJobInfo jobInfo = this.createJobInfo((MultiClusterContainer<UUID>)restoreJobIds);
        Assertions.assertThatThrownBy(() -> jobInfo.getRestoreJobId(null)).isInstanceOf(NoSuchElementException.class);
        Assertions.assertThatThrownBy(() -> jobInfo.getRestoreJobId("non-existent-cluster")).isInstanceOf(NoSuchElementException.class);
    }

    @Test
    void testGetRestoreJobIdFallbackToGetAnyValueWhenClusterIdIsNullAndNotFound() {
        MultiClusterContainer restoreJobIds = new MultiClusterContainer();
        restoreJobIds.setValue(CLUSTER_1, (Object)this.cluster1JobId);
        restoreJobIds.setValue(CLUSTER_2, (Object)this.cluster2JobId);
        CassandraJobInfo jobInfo = this.createJobInfo((MultiClusterContainer<UUID>)restoreJobIds);
        UUID resultJobId = jobInfo.getRestoreJobId();
        Assertions.assertThat((Comparable)resultJobId).isNotNull();
        Assertions.assertThat((Comparable)resultJobId).isIn(new Object[]{this.cluster1JobId, this.cluster2JobId});
    }

    @Test
    void testConstructorValidationFailsWithEmptyRestoreJobIds() {
        MultiClusterContainer emptyContainer = new MultiClusterContainer();
        BulkSparkConf mockConf = (BulkSparkConf)Mockito.mock(BulkSparkConf.class);
        TokenPartitioner mockPartitioner = (TokenPartitioner)Mockito.mock(TokenPartitioner.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new CassandraJobInfo(mockConf, emptyContainer, mockPartitioner)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("restoreJobIds cannot be empty");
    }

    @Test
    void testGetRestoreJobIdConsistencyAcrossMultipleCalls() {
        UUID expectedJobId = UUID.randomUUID();
        MultiClusterContainer restoreJobIds = MultiClusterContainer.ofSingle((Object)expectedJobId);
        CassandraJobInfo jobInfo = this.createJobInfo((MultiClusterContainer<UUID>)restoreJobIds);
        HashSet<UUID> results = new HashSet<UUID>();
        results.add(jobInfo.getRestoreJobId());
        results.add(jobInfo.getRestoreJobId());
        results.add(jobInfo.getRestoreJobId(null));
        Assertions.assertThat(results).hasSize(1);
    }

    @Test
    void testGetRestoreJobIdWithMultiClusterConsistency() {
        MultiClusterContainer restoreJobIds = new MultiClusterContainer();
        restoreJobIds.setValue(CLUSTER_1, (Object)this.cluster1JobId);
        restoreJobIds.setValue(CLUSTER_2, (Object)this.cluster2JobId);
        CassandraJobInfo jobInfo = this.createJobInfo((MultiClusterContainer<UUID>)restoreJobIds);
        Assertions.assertThat((Comparable)jobInfo.getRestoreJobId(CLUSTER_1)).isEqualTo((Object)this.cluster1JobId);
        Assertions.assertThat((Comparable)jobInfo.getRestoreJobId(CLUSTER_1)).isEqualTo((Object)this.cluster1JobId);
        Assertions.assertThat((Comparable)jobInfo.getRestoreJobId(CLUSTER_2)).isEqualTo((Object)this.cluster2JobId);
        Assertions.assertThat((Comparable)jobInfo.getRestoreJobId(CLUSTER_2)).isEqualTo((Object)this.cluster2JobId);
        UUID fallback1 = jobInfo.getRestoreJobId();
        UUID fallback2 = jobInfo.getRestoreJobId();
        Assertions.assertThat((Comparable)fallback1).isEqualTo((Object)fallback2);
    }

    private CassandraJobInfo createJobInfo(MultiClusterContainer<UUID> restoreJobIds) {
        BulkSparkConf mockConf = (BulkSparkConf)Mockito.mock(BulkSparkConf.class);
        TokenPartitioner mockPartitioner = (TokenPartitioner)Mockito.mock(TokenPartitioner.class);
        return new CassandraJobInfo(mockConf, restoreJobIds, mockPartitioner);
    }
}

