/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.bridge;

import org.apache.cassandra.bridge.CassandraVersionFeatures;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class CassandraVersionFeaturesTest {
    @Test
    public void testCassandraVersions() {
        CassandraVersionFeaturesTest.testCassandraVersion("1.2.3", 12, 3, "");
        CassandraVersionFeaturesTest.testCassandraVersion("1.2.3.4", 12, 3, "4");
        CassandraVersionFeaturesTest.testCassandraVersion("cassandra-2.0.14-v3", 20, 14, "-v3");
        CassandraVersionFeaturesTest.testCassandraVersion("cassandra-1.2.11-v1", 12, 11, "-v1");
        CassandraVersionFeaturesTest.testCassandraVersion("cassandra-1.2.11.2-tag", 12, 11, "2");
        CassandraVersionFeaturesTest.testCassandraVersion("cassandra-4.0-SNAPSHOT", 40, 0, "SNAPSHOT");
        CassandraVersionFeaturesTest.testCassandraVersion("cassandra-2.0.9-loadtest-SNAPSHOT", 20, 9, "-loadtest-SNAPSHOT");
        CassandraVersionFeaturesTest.testCassandraVersion("qwerty-cassandra-1.2.11-v1", 12, 11, "-v1");
        CassandraVersionFeaturesTest.testCassandraVersion("qwerty-cassandra-1.2.11.2-tag", 12, 11, "2");
        CassandraVersionFeaturesTest.testCassandraVersion("qwerty-cassandra-4.0-SNAPSHOT", 40, 0, "SNAPSHOT");
    }

    @Test
    public void testInvalidInput() {
        Assertions.assertThatThrownBy(() -> CassandraVersionFeatures.cassandraVersionFeaturesFromCassandraVersion((String)"qwerty")).isInstanceOf(RuntimeException.class);
    }

    private static void testCassandraVersion(String version, int major, int minor, String suffix) {
        CassandraVersionFeatures features = CassandraVersionFeatures.cassandraVersionFeaturesFromCassandraVersion((String)version);
        ((AbstractIntegerAssert)Assertions.assertThat((int)features.getMajorVersion()).as("Wrong major version for " + version + ",", new Object[0])).isEqualTo(major);
        ((AbstractIntegerAssert)Assertions.assertThat((int)features.getMinorVersion()).as("Wrong minor version for " + version + ",", new Object[0])).isEqualTo(minor);
        ((AbstractStringAssert)Assertions.assertThat((String)features.getSuffix()).as("Wrong version suffix for " + version + ",", new Object[0])).isEqualTo(suffix);
        Assertions.assertThat((String)features.getRawVersionString()).isEqualTo(version);
    }
}

