/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.apache.cassandra.spark.data.FileSystemSource;
import org.apache.cassandra.spark.data.FileType;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.stats.BufferingInputStreamStats;
import org.apache.cassandra.spark.utils.IOUtils;
import org.apache.cassandra.spark.utils.ThrowableUtils;
import org.apache.cassandra.spark.utils.streaming.BufferingInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemSSTable
extends SSTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemSSTable.class);
    private static final long serialVersionUID = -7545780596504602254L;
    private final transient Path dataFilePath;
    private final transient boolean useBufferingInputStream;
    private final transient Supplier<BufferingInputStreamStats<SSTable>> stats;

    public FileSystemSSTable(@NotNull Path dataFilePath, boolean useBufferingInputStream, @NotNull Supplier<BufferingInputStreamStats<SSTable>> stats) {
        this.dataFilePath = dataFilePath;
        this.useBufferingInputStream = useBufferingInputStream;
        this.stats = stats;
    }

    @Override
    protected InputStream openInputStream(FileType fileType) {
        Path filePath = FileType.resolveComponentFile(fileType, this.dataFilePath);
        if (filePath == null) {
            return null;
        }
        try {
            boolean isBitFormat = this.isBtiFormat();
            return this.useBufferingInputStream || isBitFormat ? new BufferingInputStream<SSTable>(new FileSystemSource<FileSystemSSTable>(this, fileType, filePath, !isBitFormat), this.stats.get()) : new BufferedInputStream(new FileInputStream(filePath.toFile()));
        }
        catch (FileNotFoundException exception) {
            return null;
        }
        catch (IOException exception) {
            Throwable cause = ThrowableUtils.rootCause(exception);
            LOGGER.warn("IOException reading local sstable", cause);
            throw new RuntimeException(cause);
        }
    }

    @Override
    public long length(FileType fileType) {
        return IOUtils.size(this.resolveComponentFile(fileType));
    }

    @Override
    public boolean isMissing(FileType fileType) {
        return this.resolveComponentFile(fileType) == null;
    }

    @Nullable
    private Path resolveComponentFile(FileType fileType) {
        return FileType.resolveComponentFile(fileType, this.dataFilePath);
    }

    @Override
    public String getDataFileName() {
        return this.dataFilePath.getFileName().toString();
    }

    public int hashCode() {
        return this.dataFilePath.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof FileSystemSSTable && this.dataFilePath.equals(((FileSystemSSTable)other).dataFilePath);
    }
}

