/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.msg;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.cdc.api.CassandraSource;
import org.apache.cassandra.cdc.msg.CdcEventBuilder;
import org.apache.cassandra.cdc.msg.RangeTombstone;
import org.apache.cassandra.cdc.msg.Value;
import org.apache.cassandra.spark.utils.ByteBufferUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdcEvent {
    @Nullable
    final List<Value> partitionKeys;
    @Nullable
    final List<Value> clusteringKeys;
    @Nullable
    final List<Value> staticColumns;
    @Nullable
    final List<Value> valueColumns;
    protected final long maxTimestampMicros;
    final TimeToLive timeToLive;
    final Map<String, List<ByteBuffer>> tombstonedCellsInComplex;
    final List<RangeTombstone> rangeTombstoneList;
    public final boolean track;
    public final String trackingId;
    public final String keyspace;
    public final String table;
    public final Kind kind;
    protected final CassandraSource cassandraSource;

    protected CdcEvent(CdcEventBuilder builder) {
        this.partitionKeys = builder.partitionKeys;
        this.clusteringKeys = builder.clusteringKeys;
        this.staticColumns = builder.staticColumns;
        this.valueColumns = builder.valueColumns;
        this.maxTimestampMicros = builder.maxTimestampMicros;
        this.timeToLive = builder.timeToLive;
        this.tombstonedCellsInComplex = builder.tombstonedCellsInComplex;
        this.rangeTombstoneList = builder.rangeTombstoneList;
        this.track = builder.track;
        this.trackingId = builder.trackingId;
        this.keyspace = builder.keyspace;
        this.table = builder.table;
        this.kind = builder.kind;
        this.cassandraSource = builder.cassandraSource;
    }

    public Kind getKind() {
        return this.kind;
    }

    public long getTimestamp(TimeUnit timeUnit) {
        return timeUnit.convert(this.maxTimestampMicros, TimeUnit.MICROSECONDS);
    }

    @NotNull
    public List<Value> getPartitionKeys() {
        return this.partitionKeys;
    }

    @Nullable
    public List<Value> getClusteringKeys() {
        return this.clusteringKeys;
    }

    private List<Value> getPrimaryKeyColumns() {
        if (this.clusteringKeys == null) {
            return this.getPartitionKeys();
        }
        ArrayList<Value> primaryKeys = new ArrayList<Value>(this.partitionKeys.size() + this.clusteringKeys.size());
        primaryKeys.addAll(this.partitionKeys);
        primaryKeys.addAll(this.clusteringKeys);
        return primaryKeys;
    }

    @Nullable
    public List<Value> getStaticColumns() {
        return this.staticColumns;
    }

    @Nullable
    public List<Value> getValueColumns() {
        return this.valueColumns;
    }

    @Nullable
    public Map<String, List<ByteBuffer>> getTombstonedCellsInComplex() {
        return this.tombstonedCellsInComplex;
    }

    @Nullable
    public List<RangeTombstone> getRangeTombstoneList() {
        return this.rangeTombstoneList;
    }

    @Nullable
    public TimeToLive getTtl() {
        return this.timeToLive;
    }

    public String getHexKey() {
        StringBuilder str = new StringBuilder();
        for (Value column : this.getPrimaryKeyColumns()) {
            str.append(ByteBufferUtils.toHexString(column.getValue())).append(':');
        }
        return str.toString();
    }

    public static class TimeToLive {
        public final int ttlInSec;
        public final int expirationTimeInSec;

        public TimeToLive(int ttlInSec, int expirationTimeInSec) {
            this.ttlInSec = ttlInSec;
            this.expirationTimeInSec = expirationTimeInSec;
        }
    }

    public static enum Kind {
        INSERT,
        UPDATE,
        DELETE,
        PARTITION_DELETE,
        ROW_DELETE,
        RANGE_DELETE,
        COMPLEX_ELEMENT_DELETE;

    }
}

