/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.types;

import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.SettableByIndexData;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.spark.data.types.BinaryBased;
import org.apache.cassandra.spark.utils.RandomUtils;

public class Inet
extends BinaryBased {
    public static final Inet INSTANCE = new Inet();

    public String name() {
        return "inet";
    }

    @Override
    public AbstractType<?> dataType() {
        return InetAddressType.instance;
    }

    @Override
    public Object randomValue(int minCollectionSize) {
        return InetAddresses.fromInteger((int)RandomUtils.RANDOM.nextInt());
    }

    @Override
    protected void setInnerValueInternal(SettableByIndexData<?> udtValue, int position, Object value) {
        udtValue.setInet(position, (InetAddress)value);
    }

    @Override
    public DataType driverDataType(boolean isFrozen) {
        return DataType.inet();
    }
}

