/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.map.hashtable;

import org.psjava.ds.map.hashtable.BucketVisitor;
import org.psjava.ds.map.hashtable.HashProber;

public class QuadraticProbing {
    public static HashProber create() {
        return new HashProber(){

            @Override
            public void probe(int start, int length, BucketVisitor visitor) {
                int round = 0;
                while (true) {
                    int factor = 0;
                    while (factor * factor < length) {
                        int p = (start + round + factor * factor) % length;
                        if (!visitor.visitAndGetContinuity(p)) {
                            return;
                        }
                        ++factor;
                    }
                    ++round;
                }
            }
        };
    }

    private QuadraticProbing() {
    }
}

