/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import com.google.common.base.Objects;
import java.io.IOException;
import java.util.UUID;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.DeserializationHelper;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.UUIDSerializer;

public class Commit {
    public static final CommitSerializer serializer = new CommitSerializer();
    public final UUID ballot;
    public final PartitionUpdate update;

    public Commit(UUID ballot, PartitionUpdate update) {
        assert (ballot != null);
        assert (update != null);
        this.ballot = ballot;
        this.update = update;
    }

    public static Commit newPrepare(DecoratedKey key, TableMetadata metadata, UUID ballot) {
        return new Commit(ballot, PartitionUpdate.emptyUpdate(metadata, key));
    }

    public static Commit newProposal(UUID ballot, PartitionUpdate update) {
        PartitionUpdate withNewTimestamp = new PartitionUpdate.Builder(update, 0).updateAllTimestamp(UUIDGen.microsTimestamp(ballot)).build();
        return new Commit(ballot, withNewTimestamp);
    }

    public static Commit emptyCommit(DecoratedKey key, TableMetadata metadata) {
        return new Commit(UUIDGen.minTimeUUID(0L), PartitionUpdate.emptyUpdate(metadata, key));
    }

    public boolean isAfter(Commit other) {
        return this.ballot.timestamp() > other.ballot.timestamp();
    }

    public boolean hasBallot(UUID ballot) {
        return this.ballot.equals(ballot);
    }

    public boolean isEmpty() {
        return this.update.isEmpty();
    }

    public Mutation makeMutation() {
        return new Mutation(this.update);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Commit commit = (Commit)o;
        return this.ballot.equals(commit.ballot) && this.update.equals(commit.update);
    }

    public int hashCode() {
        return Objects.hashCode(this.ballot, this.update);
    }

    public String toString() {
        return String.format("Commit(%s, %s)", this.ballot, this.update);
    }

    public static class CommitSerializer
    implements IVersionedSerializer<Commit> {
        @Override
        public void serialize(Commit commit, DataOutputPlus out, int version) throws IOException {
            UUIDSerializer.serializer.serialize(commit.ballot, out, version);
            PartitionUpdate.serializer.serialize(commit.update, out, version);
        }

        @Override
        public Commit deserialize(DataInputPlus in, int version) throws IOException {
            UUID ballot = UUIDSerializer.serializer.deserialize(in, version);
            PartitionUpdate update = PartitionUpdate.serializer.deserialize(in, version, DeserializationHelper.Flag.LOCAL);
            return new Commit(ballot, update);
        }

        @Override
        public long serializedSize(Commit commit, int version) {
            return UUIDSerializer.serializer.serializedSize(commit.ballot, version) + PartitionUpdate.serializer.serializedSize(commit.update, version);
        }
    }
}

