/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import org.apache.cassandra.db.rows.BaseRowIterator;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.schema.TableMetadata;

public class PartitionSerializationException
extends RuntimeException {
    public PartitionSerializationException(BaseRowIterator<Unfiltered> partition, Throwable cause) {
        super(PartitionSerializationException.buildMessage(partition), cause);
    }

    private static String buildMessage(BaseRowIterator<Unfiltered> partition) {
        TableMetadata table = partition.metadata();
        String readablePartitionkey = table.partitionKeyType.getString(partition.partitionKey().getKey());
        return String.format("Failed to serialize partition key '%s' on table '%s' in keyspace '%s'.", readablePartitionkey, table.name, table.keyspace);
    }
}

