/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.testing;

import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.cassandra.distributed.api.Feature;

public class ClusterBuilderConfiguration {
    public int nodesPerDc = 1;
    public int dcCount = 1;
    public int newNodesPerDc = 0;
    public int numDataDirsPerInstance = 1;
    public boolean dynamicPortAllocation = true;
    public final EnumSet<Feature> features = EnumSet.of(Feature.GOSSIP, Feature.JMX, Feature.NATIVE_PROTOCOL);
    public BiConsumer<ClassLoader, Integer> instanceInitializer = null;
    public String partitioner;
    public Map<String, Object> additionalInstanceConfig = null;
    public int tokenCount = 1;

    public ClusterBuilderConfiguration requestFeature(Feature feature) {
        this.features.add(feature);
        return this;
    }

    public ClusterBuilderConfiguration removeFeature(Feature feature) {
        this.features.remove(feature);
        return this;
    }

    public ClusterBuilderConfiguration nodesPerDc(int nodesPerDc) {
        this.nodesPerDc = nodesPerDc;
        return this;
    }

    public ClusterBuilderConfiguration dcCount(int dcCount) {
        this.dcCount = dcCount;
        return this;
    }

    public ClusterBuilderConfiguration newNodesPerDc(int newNodesPerDc) {
        Preconditions.checkArgument((newNodesPerDc >= 0 ? 1 : 0) != 0, (Object)"newNodesPerDc cannot be a negative number");
        this.newNodesPerDc = newNodesPerDc;
        return this;
    }

    public ClusterBuilderConfiguration numDataDirsPerInstance(int numDataDirsPerInstance) {
        this.numDataDirsPerInstance = numDataDirsPerInstance;
        return this;
    }

    public ClusterBuilderConfiguration instanceInitializer(BiConsumer<ClassLoader, Integer> instanceInitializer) {
        this.instanceInitializer = instanceInitializer;
        return this;
    }

    public ClusterBuilderConfiguration dynamicPortAllocation(boolean dynamicPortAllocation) {
        this.dynamicPortAllocation = dynamicPortAllocation;
        return this;
    }

    public ClusterBuilderConfiguration partitioner(String partitioner) {
        this.partitioner = partitioner;
        return this;
    }

    public ClusterBuilderConfiguration additionalInstanceConfig(Map<String, Object> additionalInstanceConfig) {
        this.additionalInstanceConfig = additionalInstanceConfig;
        return this;
    }

    public ClusterBuilderConfiguration tokenCount(int tokenCount) {
        this.tokenCount = tokenCount;
        return this;
    }
}

