/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.sidecar.client.SidecarInstance;
import org.apache.cassandra.sidecar.client.retry.ExponentialBackoffRetryPolicy;
import org.apache.cassandra.sidecar.client.retry.NoRetryPolicy;
import org.apache.cassandra.sidecar.client.retry.RetryPolicy;
import org.apache.cassandra.sidecar.client.selection.InstanceSelectionPolicy;
import org.apache.cassandra.sidecar.client.selection.SingleInstanceSelectionPolicy;
import org.apache.cassandra.sidecar.common.request.CassandraJmxHealthRequest;
import org.apache.cassandra.sidecar.common.request.CassandraNativeHealthRequest;
import org.apache.cassandra.sidecar.common.request.CleanSSTableUploadSessionRequest;
import org.apache.cassandra.sidecar.common.request.ClearSnapshotRequest;
import org.apache.cassandra.sidecar.common.request.ConnectedClientStatsRequest;
import org.apache.cassandra.sidecar.common.request.CreateSnapshotRequest;
import org.apache.cassandra.sidecar.common.request.GossipHealthRequest;
import org.apache.cassandra.sidecar.common.request.GossipInfoRequest;
import org.apache.cassandra.sidecar.common.request.ImportSSTableRequest;
import org.apache.cassandra.sidecar.common.request.ListOperationalJobsRequest;
import org.apache.cassandra.sidecar.common.request.ListSnapshotFilesRequest;
import org.apache.cassandra.sidecar.common.request.NodeDecommissionRequest;
import org.apache.cassandra.sidecar.common.request.NodeSettingsRequest;
import org.apache.cassandra.sidecar.common.request.OperationalJobRequest;
import org.apache.cassandra.sidecar.common.request.ReportSchemaRequest;
import org.apache.cassandra.sidecar.common.request.Request;
import org.apache.cassandra.sidecar.common.request.RingRequest;
import org.apache.cassandra.sidecar.common.request.SSTableComponentRequest;
import org.apache.cassandra.sidecar.common.request.SchemaRequest;
import org.apache.cassandra.sidecar.common.request.SidecarHealthRequest;
import org.apache.cassandra.sidecar.common.request.StreamStatsRequest;
import org.apache.cassandra.sidecar.common.request.TableStatsRequest;
import org.apache.cassandra.sidecar.common.request.TimeSkewRequest;
import org.apache.cassandra.sidecar.common.request.TokenRangeReplicasRequest;
import org.apache.cassandra.sidecar.common.request.UploadSSTableRequest;
import org.apache.cassandra.sidecar.common.request.data.Digest;
import org.apache.cassandra.sidecar.common.response.ListSnapshotFilesResponse;
import org.apache.cassandra.sidecar.common.utils.HttpRange;
import org.jetbrains.annotations.Nullable;

public class RequestContext {
    protected static final SidecarHealthRequest SIDECAR_HEALTH_REQUEST = new SidecarHealthRequest();
    @Deprecated
    protected static final CassandraNativeHealthRequest CASSANDRA_HEALTH_REQUEST = new CassandraNativeHealthRequest(true);
    protected static final CassandraNativeHealthRequest CASSANDRA_NATIVE_HEALTH_REQUEST = new CassandraNativeHealthRequest();
    protected static final CassandraJmxHealthRequest CASSANDRA_JMX_HEALTH_REQUEST = new CassandraJmxHealthRequest();
    protected static final SchemaRequest FULL_SCHEMA_REQUEST = new SchemaRequest();
    protected static final TimeSkewRequest TIME_SKEW_REQUEST = new TimeSkewRequest();
    protected static final NodeSettingsRequest NODE_SETTINGS_REQUEST = new NodeSettingsRequest();
    protected static final RingRequest RING_REQUEST = new RingRequest();
    protected static final GossipInfoRequest GOSSIP_INFO_REQUEST = new GossipInfoRequest();
    protected static final ListOperationalJobsRequest LIST_JOBS_REQUEST = new ListOperationalJobsRequest();
    protected static final NodeDecommissionRequest NODE_DECOMMISSION_REQUEST = new NodeDecommissionRequest();
    protected static final StreamStatsRequest STREAM_STATS_REQUEST = new StreamStatsRequest();
    protected static final RetryPolicy DEFAULT_NO_RETRY_POLICY = new NoRetryPolicy();
    protected static final RetryPolicy DEFAULT_EXPONENTIAL_BACKOFF_RETRY_POLICY = new ExponentialBackoffRetryPolicy(10, 500L, 60000L);
    private final InstanceSelectionPolicy instanceSelectionPolicy;
    private final Request request;
    private final RetryPolicy retryPolicy;
    private final Map<String, String> customHeaders;

    private RequestContext(Builder builder) {
        this.instanceSelectionPolicy = builder.instanceSelectionPolicy;
        this.request = builder.request;
        this.retryPolicy = builder.retryPolicy;
        this.customHeaders = Collections.unmodifiableMap(builder.customHeaders);
    }

    public InstanceSelectionPolicy instanceSelectionPolicy() {
        return this.instanceSelectionPolicy;
    }

    public RetryPolicy retryPolicy() {
        return this.retryPolicy;
    }

    public Request request() {
        return this.request;
    }

    public Map<String, String> customHeaders() {
        return this.customHeaders;
    }

    public static final class Builder {
        private InstanceSelectionPolicy instanceSelectionPolicy;
        private Request request;
        private RetryPolicy retryPolicy = DEFAULT_NO_RETRY_POLICY;
        private final Map<String, String> customHeaders;

        public Builder() {
            this.customHeaders = new HashMap<String, String>();
        }

        private Builder(Builder builder) {
            this.request = builder.request;
            this.instanceSelectionPolicy = builder.instanceSelectionPolicy;
            this.retryPolicy = builder.retryPolicy;
            this.customHeaders = new HashMap<String, String>(builder.customHeaders);
        }

        public Builder instanceSelectionPolicy(InstanceSelectionPolicy instanceSelectionPolicy) {
            this.instanceSelectionPolicy = instanceSelectionPolicy;
            return this;
        }

        public Builder singleInstanceSelectionPolicy(SidecarInstance sidecarInstance) {
            return this.instanceSelectionPolicy(new SingleInstanceSelectionPolicy(sidecarInstance));
        }

        public Builder request(Request request) {
            this.request = request;
            return this;
        }

        public Builder retryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public Builder sidecarHealthRequest() {
            return this.request((Request)SIDECAR_HEALTH_REQUEST);
        }

        @Deprecated
        public Builder cassandraHealthRequest() {
            return this.request((Request)CASSANDRA_HEALTH_REQUEST);
        }

        public Builder cassandraNativeHealthRequest() {
            return this.request((Request)CASSANDRA_NATIVE_HEALTH_REQUEST);
        }

        public Builder cassandraJmxHealthRequest() {
            return this.request((Request)CASSANDRA_JMX_HEALTH_REQUEST);
        }

        public Builder schemaRequest() {
            return this.request((Request)FULL_SCHEMA_REQUEST);
        }

        public Builder schemaRequest(String keyspace) {
            return this.request((Request)new SchemaRequest(keyspace));
        }

        public Builder timeSkewRequest() {
            return this.request((Request)TIME_SKEW_REQUEST);
        }

        public Builder tokenRangeReplicasRequest(String keyspace) {
            return this.request((Request)new TokenRangeReplicasRequest(keyspace));
        }

        public Builder nodeSettingsRequest() {
            return this.request((Request)NODE_SETTINGS_REQUEST);
        }

        public Builder ringRequest() {
            return this.request((Request)RING_REQUEST);
        }

        public Builder ringRequest(String keyspace) {
            return this.request((Request)new RingRequest(keyspace));
        }

        public Builder gossipInfoRequest() {
            return this.request((Request)GOSSIP_INFO_REQUEST);
        }

        public Builder gossipHealthRequest() {
            return this.request((Request)new GossipHealthRequest());
        }

        public Builder ssTableComponentRequest(String keyspace, String tableName, String snapshotName, String componentName, HttpRange range) {
            return this.request((Request)new SSTableComponentRequest(keyspace, tableName, snapshotName, componentName, range));
        }

        public Builder ssTableComponentRequest(ListSnapshotFilesResponse.FileInfo fileInfo, HttpRange range) {
            return this.request((Request)new SSTableComponentRequest(fileInfo, range));
        }

        public Builder listSnapshotFilesRequest(String keyspace, String tableName, String snapshotName) {
            return this.listSnapshotFilesRequest(keyspace, tableName, snapshotName, false);
        }

        public Builder createSnapshotRequest(String keyspace, String tableName, String snapshotName, @Nullable String snapshotTTL) {
            return this.request((Request)new CreateSnapshotRequest(keyspace, tableName, snapshotName, snapshotTTL));
        }

        public Builder listSnapshotFilesRequest(String keyspace, String tableName, String snapshotName, boolean includeSecondaryIndexFiles) {
            return this.request((Request)new ListSnapshotFilesRequest(keyspace, tableName, snapshotName, includeSecondaryIndexFiles));
        }

        public Builder clearSnapshotRequest(String keyspace, String tableName, String snapshotName) {
            return this.request((Request)new ClearSnapshotRequest(keyspace, tableName, snapshotName));
        }

        public Builder cleanSSTableUploadSessionRequest(String uploadId) {
            return this.request((Request)new CleanSSTableUploadSessionRequest(uploadId));
        }

        public Builder importSSTableRequest(String keyspace, String tableName, String uploadId, ImportSSTableRequest.ImportOptions importOptions) {
            return this.request((Request)new ImportSSTableRequest(keyspace, tableName, uploadId, importOptions));
        }

        public Builder uploadSSTableRequest(String keyspace, String tableName, String uploadId, String component, Digest digest, String filename) {
            return this.request((Request)new UploadSSTableRequest(keyspace, tableName, uploadId, component, digest, filename));
        }

        public Builder reportSchemaRequest() {
            return this.request((Request)new ReportSchemaRequest());
        }

        public Builder connectedClientStatsRequest() {
            return this.request((Request)new ConnectedClientStatsRequest());
        }

        public Builder tableStatsRequest(String keyspace, String table) {
            return this.request((Request)new TableStatsRequest(keyspace, table));
        }

        public Builder operationalJobRequest(UUID jobId) {
            return this.request((Request)new OperationalJobRequest(jobId));
        }

        public Builder listOperationalJobsRequest() {
            return this.request((Request)LIST_JOBS_REQUEST);
        }

        public Builder nodeDecommissionRequest() {
            return this.request((Request)NODE_DECOMMISSION_REQUEST);
        }

        public Builder streamsStatsRequest() {
            return this.request((Request)STREAM_STATS_REQUEST);
        }

        public Builder noRetryPolicy() {
            return this.retryPolicy(DEFAULT_NO_RETRY_POLICY);
        }

        public Builder exponentialBackoffRetryPolicy() {
            return this.retryPolicy(DEFAULT_EXPONENTIAL_BACKOFF_RETRY_POLICY);
        }

        public Builder exponentialBackoffRetryPolicy(int maxRetries, long retryDelayMillis, long maxRetryDelayMillis) {
            return this.retryPolicy(new ExponentialBackoffRetryPolicy(maxRetries, retryDelayMillis, maxRetryDelayMillis));
        }

        public Builder addCustomHeader(String name, String value) {
            this.customHeaders.put(name, value);
            return this;
        }

        public Builder copy() {
            return new Builder(this);
        }

        public RequestContext build() {
            return new RequestContext(this);
        }
    }
}

