/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.core.net.impl;

import java.util.function.BiConsumer;
import o.a.c.sidecar.client.shaded.io.netty.channel.Channel;
import o.a.c.sidecar.client.shaded.io.netty.channel.ChannelHandler;
import o.a.c.sidecar.client.shaded.io.netty.channel.ChannelHandlerContext;
import o.a.c.sidecar.client.shaded.io.netty.channel.ChannelPipeline;
import o.a.c.sidecar.client.shaded.io.netty.channel.ChannelPromise;
import o.a.c.sidecar.client.shaded.io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import o.a.c.sidecar.client.shaded.io.netty.handler.logging.LoggingHandler;
import o.a.c.sidecar.client.shaded.io.netty.handler.stream.ChunkedWriteHandler;
import o.a.c.sidecar.client.shaded.io.netty.handler.timeout.IdleStateHandler;
import o.a.c.sidecar.client.shaded.io.netty.handler.traffic.GlobalTrafficShapingHandler;
import o.a.c.sidecar.client.shaded.io.netty.util.concurrent.GenericFutureListener;
import o.a.c.sidecar.client.shaded.io.vertx.core.AsyncResult;
import o.a.c.sidecar.client.shaded.io.vertx.core.Closeable;
import o.a.c.sidecar.client.shaded.io.vertx.core.Future;
import o.a.c.sidecar.client.shaded.io.vertx.core.Handler;
import o.a.c.sidecar.client.shaded.io.vertx.core.Promise;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.ContextInternal;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.VertxInternal;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.future.PromiseInternal;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.logging.Logger;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.logging.LoggerFactory;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.NetServer;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.NetServerOptions;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.NetSocket;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.SocketAddress;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.impl.HAProxyMessageCompletionHandler;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.impl.NetSocketImpl;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.impl.SslChannelProvider;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.impl.SslHandshakeCompletionHandler;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.impl.TCPServerBase;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.impl.VertxHandler;
import o.a.c.sidecar.client.shaded.io.vertx.core.spi.metrics.Metrics;
import o.a.c.sidecar.client.shaded.io.vertx.core.spi.metrics.MetricsProvider;
import o.a.c.sidecar.client.shaded.io.vertx.core.spi.metrics.TCPMetrics;
import o.a.c.sidecar.client.shaded.io.vertx.core.spi.metrics.VertxMetrics;
import o.a.c.sidecar.client.shaded.io.vertx.core.streams.ReadStream;

public class NetServerImpl
extends TCPServerBase
implements Closeable,
MetricsProvider,
NetServer {
    private static final Logger log = LoggerFactory.getLogger(NetServerImpl.class);
    private final NetSocketStream connectStream = new NetSocketStream();
    private long demand = Long.MAX_VALUE;
    private Handler<NetSocket> handler;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;

    public NetServerImpl(VertxInternal vertx, NetServerOptions options) {
        super(vertx, options);
    }

    private synchronized void pauseAccepting() {
        this.demand = 0L;
    }

    private synchronized void resumeAccepting() {
        this.demand = Long.MAX_VALUE;
    }

    private synchronized void fetchAccepting(long amount) {
        if (amount > 0L) {
            this.demand += amount;
            if (this.demand < 0L) {
                this.demand = Long.MAX_VALUE;
            }
        }
    }

    protected synchronized boolean accept() {
        boolean accept;
        boolean bl = accept = this.demand > 0L;
        if (accept && this.demand != Long.MAX_VALUE) {
            --this.demand;
        }
        return accept;
    }

    @Override
    public synchronized Handler<NetSocket> connectHandler() {
        return this.handler;
    }

    @Override
    public synchronized NetServer connectHandler(Handler<NetSocket> handler) {
        if (this.isListening()) {
            throw new IllegalStateException("Cannot set connectHandler when server is listening");
        }
        this.handler = handler;
        return this;
    }

    @Override
    public synchronized NetServer exceptionHandler(Handler<Throwable> handler) {
        if (this.isListening()) {
            throw new IllegalStateException("Cannot set exceptionHandler when server is listening");
        }
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    protected TCPMetrics<?> createMetrics(SocketAddress localAddress) {
        VertxMetrics vertxMetrics = this.vertx.metricsSPI();
        if (vertxMetrics != null) {
            return vertxMetrics.createNetServerMetrics(this.options, localAddress);
        }
        return null;
    }

    @Override
    public Future<Void> close() {
        ContextInternal context = this.vertx.getOrCreateContext();
        PromiseInternal<Void> promise = context.promise();
        this.close((Promise<Void>)promise);
        return promise.future();
    }

    @Override
    protected BiConsumer<Channel, SslChannelProvider> childHandler(ContextInternal context, SocketAddress socketAddress, GlobalTrafficShapingHandler trafficShapingHandler) {
        return new NetServerWorker(context, this.handler, this.exceptionHandler, trafficShapingHandler);
    }

    @Override
    public synchronized Future<NetServer> listen(SocketAddress localAddress) {
        if (localAddress == null) {
            throw new NullPointerException("No null bind local address");
        }
        if (this.handler == null) {
            throw new IllegalStateException("Set connect handler first");
        }
        return this.bind(localAddress).map(this);
    }

    @Override
    public Future<NetServer> listen() {
        return this.listen(this.options.getPort(), this.options.getHost());
    }

    @Override
    public ReadStream<NetSocket> connectStream() {
        return this.connectStream;
    }

    @Override
    public void close(Handler<AsyncResult<Void>> completionHandler) {
        ContextInternal context = this.vertx.getOrCreateContext();
        PromiseInternal<Void> promise = context.promise();
        this.close((Promise<Void>)promise);
        promise.future().onComplete(completionHandler);
    }

    @Override
    public synchronized void close(Promise<Void> completion) {
        super.close(completion);
        Handler<Void> handler = this.endHandler;
        if (this.endHandler != null) {
            this.endHandler = null;
            completion.future().onComplete(ar -> handler.handle(null));
        }
    }

    public boolean isClosed() {
        return !this.isListening();
    }

    protected void initChannel(ChannelPipeline pipeline, boolean ssl) {
        if (this.options.getLogActivity()) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingHandler(this.options.getActivityLogDataFormat()));
        }
        if (ssl || !this.vertx.transport().supportFileRegion() || this.options.getTrafficShapingOptions() != null && this.options.getTrafficShapingOptions().getOutboundGlobalBandwidth() > 0L) {
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        }
        int idleTimeout = this.options.getIdleTimeout();
        int readIdleTimeout = this.options.getReadIdleTimeout();
        int writeIdleTimeout = this.options.getWriteIdleTimeout();
        if (idleTimeout > 0 || readIdleTimeout > 0 || writeIdleTimeout > 0) {
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(readIdleTimeout, writeIdleTimeout, idleTimeout, this.options.getIdleTimeoutUnit()));
        }
    }

    private class NetSocketStream
    implements ReadStream<NetSocket> {
        private NetSocketStream() {
        }

        public NetSocketStream handler(Handler<NetSocket> handler) {
            NetServerImpl.this.connectHandler(handler);
            return this;
        }

        public NetSocketStream pause() {
            NetServerImpl.this.pauseAccepting();
            return this;
        }

        public NetSocketStream resume() {
            NetServerImpl.this.resumeAccepting();
            return this;
        }

        @Override
        public ReadStream<NetSocket> fetch(long amount) {
            NetServerImpl.this.fetchAccepting(amount);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NetSocketStream endHandler(Handler<Void> handler) {
            NetServerImpl netServerImpl = NetServerImpl.this;
            synchronized (netServerImpl) {
                NetServerImpl.this.endHandler = handler;
                return this;
            }
        }

        @Override
        public NetSocketStream exceptionHandler(Handler<Throwable> handler) {
            return this;
        }
    }

    private class NetServerWorker
    implements BiConsumer<Channel, SslChannelProvider> {
        private final ContextInternal context;
        private final Handler<NetSocket> connectionHandler;
        private final Handler<Throwable> exceptionHandler;
        private final GlobalTrafficShapingHandler trafficShapingHandler;

        NetServerWorker(ContextInternal context, Handler<NetSocket> connectionHandler, Handler<Throwable> exceptionHandler, GlobalTrafficShapingHandler trafficShapingHandler) {
            this.context = context;
            this.connectionHandler = connectionHandler;
            this.exceptionHandler = exceptionHandler;
            this.trafficShapingHandler = trafficShapingHandler;
        }

        @Override
        public void accept(Channel ch, SslChannelProvider sslChannelProvider) {
            if (!NetServerImpl.this.accept()) {
                ch.close();
                return;
            }
            if (HAProxyMessageCompletionHandler.canUseProxyProtocol(NetServerImpl.this.options.isUseProxyProtocol())) {
                IdleStateHandler idle;
                o.a.c.sidecar.client.shaded.io.netty.util.concurrent.Promise<Channel> p = ch.eventLoop().newPromise();
                ch.pipeline().addLast(new ChannelHandler[]{new HAProxyMessageDecoder()});
                if (NetServerImpl.this.options.getProxyProtocolTimeout() > 0L) {
                    idle = new IdleStateHandler(0L, 0L, NetServerImpl.this.options.getProxyProtocolTimeout(), NetServerImpl.this.options.getProxyProtocolTimeoutUnit());
                    ch.pipeline().addLast("idle", (ChannelHandler)idle);
                } else {
                    idle = null;
                }
                ch.pipeline().addLast(new HAProxyMessageCompletionHandler(p));
                p.addListener(future -> {
                    if (future.isSuccess()) {
                        if (idle != null) {
                            ch.pipeline().remove(idle);
                        }
                        this.configurePipeline((Channel)future.getNow(), sslChannelProvider);
                    } else {
                        this.handleException(future.cause());
                    }
                });
            } else {
                this.configurePipeline(ch, sslChannelProvider);
            }
        }

        private void configurePipeline(Channel ch, SslChannelProvider sslChannelProvider) {
            if (NetServerImpl.this.options.isSsl()) {
                ch.pipeline().addLast("ssl", sslChannelProvider.createServerHandler());
                ChannelPromise p = ch.newPromise();
                ch.pipeline().addLast("handshaker", (ChannelHandler)new SslHandshakeCompletionHandler(p));
                p.addListener((GenericFutureListener<? extends o.a.c.sidecar.client.shaded.io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<o.a.c.sidecar.client.shaded.io.netty.util.concurrent.Future>)future -> {
                    if (future.isSuccess()) {
                        this.connected(ch, sslChannelProvider);
                    } else {
                        this.handleException(future.cause());
                    }
                }));
            } else {
                this.connected(ch, sslChannelProvider);
            }
            if (this.trafficShapingHandler != null) {
                ch.pipeline().addFirst("globalTrafficShaping", (ChannelHandler)this.trafficShapingHandler);
            }
        }

        private void handleException(Throwable cause) {
            if (this.exceptionHandler != null) {
                this.context.emit(v -> this.exceptionHandler.handle(cause));
            }
        }

        private void connected(Channel ch, SslChannelProvider sslChannelProvider) {
            NetServerImpl.this.initChannel(ch.pipeline(), NetServerImpl.this.options.isSsl());
            Metrics metrics = NetServerImpl.this.getMetrics();
            VertxHandler<NetSocketImpl> handler = VertxHandler.create(arg_0 -> this.lambda$connected$3(sslChannelProvider, (TCPMetrics)metrics, arg_0));
            handler.removeHandler(NetSocketImpl::unregisterEventBusHandler);
            handler.addHandler(arg_0 -> this.lambda$connected$4((TCPMetrics)metrics, arg_0));
            ch.pipeline().addLast("handler", handler);
        }

        private /* synthetic */ void lambda$connected$4(TCPMetrics metrics, NetSocketImpl conn) {
            if (metrics != null) {
                conn.metric(metrics.connected(conn.remoteAddress(), conn.remoteName()));
            }
            conn.registerEventBusHandler();
            this.context.emit(conn, this.connectionHandler::handle);
        }

        private /* synthetic */ NetSocketImpl lambda$connected$3(SslChannelProvider sslChannelProvider, TCPMetrics metrics, ChannelHandlerContext ctx) {
            return new NetSocketImpl(this.context, ctx, sslChannelProvider, metrics, NetServerImpl.this.options.isRegisterWriteHandler());
        }
    }
}

