/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.core.impl.resolver;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import o.a.c.sidecar.client.shaded.io.netty.channel.EventLoop;
import o.a.c.sidecar.client.shaded.io.netty.channel.socket.SocketChannel;
import o.a.c.sidecar.client.shaded.io.netty.resolver.AddressResolverGroup;
import o.a.c.sidecar.client.shaded.io.netty.resolver.HostsFileEntries;
import o.a.c.sidecar.client.shaded.io.netty.resolver.HostsFileEntriesResolver;
import o.a.c.sidecar.client.shaded.io.netty.resolver.HostsFileParser;
import o.a.c.sidecar.client.shaded.io.netty.resolver.NameResolver;
import o.a.c.sidecar.client.shaded.io.netty.resolver.ResolvedAddressTypes;
import o.a.c.sidecar.client.shaded.io.netty.resolver.RoundRobinInetAddressResolver;
import o.a.c.sidecar.client.shaded.io.netty.resolver.dns.DefaultDnsCache;
import o.a.c.sidecar.client.shaded.io.netty.resolver.dns.DefaultDnsServerAddressStreamProvider;
import o.a.c.sidecar.client.shaded.io.netty.resolver.dns.DnsAddressResolverGroup;
import o.a.c.sidecar.client.shaded.io.netty.resolver.dns.DnsNameResolverBuilder;
import o.a.c.sidecar.client.shaded.io.netty.resolver.dns.DnsServerAddressStream;
import o.a.c.sidecar.client.shaded.io.netty.resolver.dns.DnsServerAddressStreamProvider;
import o.a.c.sidecar.client.shaded.io.netty.resolver.dns.DnsServerAddresses;
import o.a.c.sidecar.client.shaded.io.netty.util.NetUtil;
import o.a.c.sidecar.client.shaded.io.netty.util.internal.ObjectUtil;
import o.a.c.sidecar.client.shaded.io.vertx.core.Handler;
import o.a.c.sidecar.client.shaded.io.vertx.core.VertxException;
import o.a.c.sidecar.client.shaded.io.vertx.core.buffer.Buffer;
import o.a.c.sidecar.client.shaded.io.vertx.core.dns.AddressResolverOptions;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.AddressResolver;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.ContextInternal;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.VertxInternal;
import o.a.c.sidecar.client.shaded.io.vertx.core.spi.resolver.ResolverProvider;

public class DnsResolverProvider
implements ResolverProvider,
HostsFileEntriesResolver {
    private final VertxInternal vertx;
    private final List<ResolverRegistration> resolvers = Collections.synchronizedList(new ArrayList());
    private AddressResolverGroup<InetSocketAddress> resolverGroup;
    private final List<InetSocketAddress> serverList = new ArrayList<InetSocketAddress>();
    private final String hostsPath;
    private final Buffer hostsValue;
    private final AtomicLong refreshTimestamp = new AtomicLong();
    private final long hostsRefreshPeriodNanos;
    private volatile HostsFileEntries parsedHostsFile = new HostsFileEntries(Collections.emptyMap(), Collections.emptyMap());

    public static DnsResolverProvider create(VertxInternal vertx, AddressResolverOptions options) {
        DnsResolverProvider provider = new DnsResolverProvider(vertx, options);
        provider.refresh();
        return provider;
    }

    private DnsResolverProvider(VertxInternal vertx, final AddressResolverOptions options) {
        List<String> dnsServers = options.getServers();
        if (dnsServers != null && dnsServers.size() > 0) {
            for (String dnsServer : dnsServers) {
                int port;
                String ipAddress;
                int sep = dnsServer.indexOf(58);
                if (sep != -1) {
                    ipAddress = dnsServer.substring(0, sep);
                    port = Integer.parseInt(dnsServer.substring(sep + 1));
                } else {
                    ipAddress = dnsServer;
                    port = 53;
                }
                try {
                    this.serverList.add(new InetSocketAddress(InetAddress.getByAddress(NetUtil.createByteArrayFromIpAddressString(ipAddress)), port));
                }
                catch (UnknownHostException e) {
                    throw new VertxException(e);
                }
            }
        } else {
            InetSocketAddress address;
            DnsServerAddressStream stream = DefaultDnsServerAddressStreamProvider.defaultAddresses().stream();
            HashSet<InetSocketAddress> all = new HashSet<InetSocketAddress>();
            while (!all.contains(address = stream.next())) {
                this.serverList.add(address);
                all.add(address);
            }
        }
        DnsServerAddresses nameServerAddresses = options.isRotateServers() ? DnsServerAddresses.rotational(this.serverList) : DnsServerAddresses.sequential(this.serverList);
        DnsServerAddressStreamProvider nameServerAddressProvider = hostname -> nameServerAddresses.stream();
        int minTtl = ObjectUtil.intValue(options.getCacheMinTimeToLive(), 0);
        int maxTtl = ObjectUtil.intValue(options.getCacheMaxTimeToLive(), Integer.MAX_VALUE);
        int negativeTtl = ObjectUtil.intValue(options.getCacheNegativeTimeToLive(), 0);
        DefaultDnsCache resolveCache = new DefaultDnsCache(minTtl, maxTtl, negativeTtl);
        DefaultDnsCache authoritativeDnsServerCache = new DefaultDnsCache(minTtl, maxTtl, negativeTtl);
        this.vertx = vertx;
        this.hostsPath = options.getHostsPath();
        this.hostsValue = options.getHostsValue();
        this.hostsRefreshPeriodNanos = options.getHostsRefreshPeriod();
        DnsNameResolverBuilder builder = new DnsNameResolverBuilder();
        builder.hostsFileEntriesResolver(this);
        builder.channelFactory(() -> vertx.transport().datagramChannel());
        builder.socketChannelFactory(() -> (SocketChannel)vertx.transport().channelFactory(false).newChannel());
        builder.nameServerProvider(nameServerAddressProvider);
        builder.optResourceEnabled(options.isOptResourceEnabled());
        builder.resolveCache(resolveCache);
        builder.authoritativeDnsServerCache(authoritativeDnsServerCache);
        builder.queryTimeoutMillis(options.getQueryTimeout());
        builder.maxQueriesPerResolve(options.getMaxQueries());
        builder.recursionDesired(options.getRdFlag());
        if (options.getSearchDomains() != null) {
            builder.searchDomains(options.getSearchDomains());
            int ndots = options.getNdots();
            if (ndots == -1) {
                ndots = AddressResolver.DEFAULT_NDOTS_RESOLV_OPTION;
            }
            builder.ndots(ndots);
        }
        this.resolverGroup = new DnsAddressResolverGroup(builder){

            @Override
            protected o.a.c.sidecar.client.shaded.io.netty.resolver.AddressResolver<InetSocketAddress> newAddressResolver(EventLoop eventLoop, NameResolver<InetAddress> resolver) throws Exception {
                o.a.c.sidecar.client.shaded.io.netty.resolver.AddressResolver<InetSocketAddress> addressResolver = options.isRoundRobinInetAddress() ? new RoundRobinInetAddressResolver(eventLoop, resolver).asAddressResolver() : super.newAddressResolver(eventLoop, resolver);
                DnsResolverProvider.this.resolvers.add(new ResolverRegistration(addressResolver, eventLoop));
                return addressResolver;
            }
        };
    }

    @Override
    public InetAddress address(String inetHost, ResolvedAddressTypes resolvedAddressTypes) {
        InetAddress address;
        if (inetHost.endsWith(".")) {
            inetHost = inetHost.substring(0, inetHost.length() - 1);
        }
        if (this.hostsRefreshPeriodNanos > 0L) {
            this.ensureHostsFileFresh(this.hostsRefreshPeriodNanos);
        }
        if ((address = this.lookup(inetHost, resolvedAddressTypes)) == null) {
            address = this.lookup(inetHost.toLowerCase(Locale.ENGLISH), resolvedAddressTypes);
        }
        return address;
    }

    InetAddress lookup(String inetHost, ResolvedAddressTypes resolvedAddressTypes) {
        switch (resolvedAddressTypes) {
            case IPV4_ONLY: {
                return this.parsedHostsFile.inet4Entries().get(inetHost);
            }
            case IPV6_ONLY: {
                return this.parsedHostsFile.inet6Entries().get(inetHost);
            }
            case IPV4_PREFERRED: {
                Inet4Address inet4Address = this.parsedHostsFile.inet4Entries().get(inetHost);
                return inet4Address != null ? inet4Address : (InetAddress)this.parsedHostsFile.inet6Entries().get(inetHost);
            }
            case IPV6_PREFERRED: {
                Inet6Address inet6Address = this.parsedHostsFile.inet6Entries().get(inetHost);
                return inet6Address != null ? inet6Address : (InetAddress)this.parsedHostsFile.inet4Entries().get(inetHost);
            }
        }
        throw new IllegalArgumentException("Unknown ResolvedAddressTypes " + (Object)((Object)resolvedAddressTypes));
    }

    public List<InetSocketAddress> nameServerAddresses() {
        return this.serverList;
    }

    @Override
    public AddressResolverGroup<InetSocketAddress> resolver(AddressResolverOptions options) {
        return this.resolverGroup;
    }

    @Override
    public void close(Handler<Void> doneHandler) {
        ContextInternal context = this.vertx.getOrCreateContext();
        ResolverRegistration[] registrations = this.resolvers.toArray(new ResolverRegistration[0]);
        if (registrations.length == 0) {
            context.runOnContext(doneHandler);
            return;
        }
        AtomicInteger count = new AtomicInteger(registrations.length);
        for (ResolverRegistration registration : registrations) {
            Runnable task = () -> {
                registration.resolver.close();
                if (count.decrementAndGet() == 0) {
                    context.runOnContext(doneHandler);
                }
            };
            if (registration.executor.inEventLoop()) {
                task.run();
                continue;
            }
            registration.executor.execute(task);
        }
    }

    public void refresh() {
        this.ensureHostsFileFresh(0L);
    }

    private void ensureHostsFileFresh(long refreshPeriodNanos) {
        long prev = this.refreshTimestamp.get();
        long now = System.nanoTime();
        if (now - prev >= refreshPeriodNanos && this.refreshTimestamp.compareAndSet(prev, now)) {
            this.refreshHostsFile();
        }
    }

    private void refreshHostsFile() {
        HostsFileEntries entries;
        if (this.hostsPath != null) {
            File file = this.vertx.resolveFile(this.hostsPath).getAbsoluteFile();
            try {
                if (!file.exists() || !file.isFile()) {
                    throw new IOException();
                }
                entries = HostsFileParser.parse(file);
            }
            catch (IOException e) {
                throw new VertxException("Cannot read hosts file " + file.getAbsolutePath());
            }
        } else if (this.hostsValue != null) {
            try {
                entries = HostsFileParser.parse(new StringReader(this.hostsValue.toString()));
            }
            catch (IOException e) {
                throw new VertxException("Cannot read hosts config ", e);
            }
        } else {
            entries = HostsFileParser.parseSilently();
        }
        this.parsedHostsFile = entries;
    }

    private static class ResolverRegistration {
        private final o.a.c.sidecar.client.shaded.io.netty.resolver.AddressResolver<InetSocketAddress> resolver;
        private final EventLoop executor;

        ResolverRegistration(o.a.c.sidecar.client.shaded.io.netty.resolver.AddressResolver<InetSocketAddress> resolver, EventLoop executor) {
            this.resolver = resolver;
            this.executor = executor;
        }
    }
}

