/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.common.request.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import o.a.c.sidecar.client.shaded.common.request.data.Digest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XXHash32Digest
implements Digest {
    @NotNull
    private final String value;
    @Nullable
    private final String seedHex;

    public XXHash32Digest(String value) {
        this(value, null);
    }

    public XXHash32Digest(String value, int seed) {
        this(value, Integer.toHexString(seed));
    }

    public XXHash32Digest(@NotNull String value, @Nullable String seedHex) {
        this.value = Objects.requireNonNull(value, "value is required");
        this.seedHex = seedHex;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Nullable
    public String seedHex() {
        return this.seedHex;
    }

    @Override
    public String algorithm() {
        return "XXHash32";
    }

    @Override
    public Map<String, String> headers() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("cassandra-content-xxhash32", this.value);
        if (this.seedHex != null) {
            headers.put("cassandra-content-xxhash32-seed", this.seedHex);
        }
        return headers;
    }
}

