/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.bridge;

import com.google.common.collect.ImmutableMap;
import java.nio.file.Path;
import java.util.Map;
import org.apache.cassandra.bridge.AbstractCdcBridgeImplementation;
import org.apache.cassandra.bridge.BridgeInitializationParameters;
import org.apache.cassandra.bridge.CassandraTypesImplementation;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.ParameterizedClass;
import org.apache.cassandra.db.commitlog.CommitLogSegmentManagerCDC;
import org.apache.cassandra.security.EncryptionContext;

public class CdcBridgeImplementation
extends AbstractCdcBridgeImplementation {
    public static volatile boolean setup = false;

    public static void setup(Path path, int commitLogSegmentSize, boolean enableCompression) {
        CassandraTypesImplementation.setup((BridgeInitializationParameters)BridgeInitializationParameters.fromEnvironment());
        CdcBridgeImplementation.setCDC(path, commitLogSegmentSize, enableCompression);
    }

    protected static synchronized void setCDC(Path path, int commitLogSegmentSize, boolean enableCompression) {
        if (setup) {
            return;
        }
        Path commitLogPath = path.resolve("commitlog");
        DatabaseDescriptor.getRawConfig().commitlog_directory = commitLogPath.toString();
        DatabaseDescriptor.getRawConfig().hints_directory = path.resolve("hints").toString();
        DatabaseDescriptor.getRawConfig().saved_caches_directory = path.resolve("saved_caches").toString();
        DatabaseDescriptor.getRawConfig().cdc_raw_directory = path.resolve("cdc").toString();
        DatabaseDescriptor.setCDCEnabled((boolean)true);
        DatabaseDescriptor.setCDCSpaceInMB((int)1024);
        DatabaseDescriptor.setCommitLogSync((Config.CommitLogSync)Config.CommitLogSync.periodic);
        if (enableCompression) {
            DatabaseDescriptor.setCommitLogCompression((ParameterizedClass)new ParameterizedClass("LZ4Compressor", (Map)ImmutableMap.of()));
        }
        DatabaseDescriptor.setEncryptionContext((EncryptionContext)new EncryptionContext());
        DatabaseDescriptor.setCommitLogSyncPeriod((int)30);
        DatabaseDescriptor.setCommitLogMaxCompressionBuffersPerPool((int)3);
        DatabaseDescriptor.setCommitLogSyncGroupWindow((double)30.0);
        DatabaseDescriptor.setCommitLogSegmentSize((int)commitLogSegmentSize);
        DatabaseDescriptor.getRawConfig().commitlog_total_space_in_mb = 1024;
        DatabaseDescriptor.setCommitLogSegmentMgrProvider(commitLog -> new CommitLogSegmentManagerCDC(commitLog, commitLogPath.toString()));
        setup = true;
    }
}

