/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.example;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.apache.cassandra.spark.KryoRegister;
import org.apache.cassandra.spark.bulkwriter.BulkSparkConf;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCassandraJob {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private JobConfiguration configuration;

    protected abstract JobConfiguration configureJob(SparkContext var1, SparkConf var2);

    public void start(String[] args) {
        this.logger.info("Starting Spark job with args={}", (Object)Arrays.toString(args));
        SparkConf sparkConf = new SparkConf().setAppName("Sample Spark Cassandra Bulk Reader Job").set("spark.master", "local[8]");
        BulkSparkConf.setupSparkConf((SparkConf)sparkConf, (boolean)true);
        KryoRegister.setup((SparkConf)sparkConf);
        SparkSession spark = SparkSession.builder().config(sparkConf).getOrCreate();
        SparkContext sc = spark.sparkContext();
        SQLContext sql = spark.sqlContext();
        this.logger.info("Spark Conf: " + sparkConf.toDebugString());
        this.configuration = this.configureJob(sc, sparkConf);
        long rowCount = this.configuration.rowCount;
        try {
            Dataset<Row> written = null;
            if (this.configuration.shouldWrite()) {
                written = this.write(rowCount, sql, sc);
            }
            Dataset<Row> read = null;
            if (this.configuration.shouldRead()) {
                read = this.read(rowCount, sql);
            }
            if (this.configuration.shouldWrite() && this.configuration.shouldRead()) {
                AbstractCassandraJob.checkSmallDataFrameEquality(written, read);
            }
            this.logger.info("Finished Spark job, shutting down...");
            sc.stop();
        }
        catch (Throwable throwable) {
            this.logger.error("Unexpected exception executing Spark job", throwable);
            try {
                sc.stop();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }

    protected Dataset<Row> write(long rowCount, SQLContext sql, SparkContext sc) {
        StructType schema = new StructType().add("id", DataTypes.LongType, false).add("course", DataTypes.BinaryType, false).add("marks", DataTypes.LongType, false);
        JavaSparkContext javaSparkContext = JavaSparkContext.fromSparkContext((SparkContext)sc);
        int parallelism = sc.defaultParallelism();
        JavaRDD<Row> rows = AbstractCassandraJob.genDataset(javaSparkContext, rowCount, parallelism);
        Dataset df = sql.createDataFrame(rows, schema);
        DataFrameWriter writer = df.write().format("org.apache.cassandra.spark.sparksql.CassandraDataSink");
        writer.options(this.configuration.writeOptions);
        writer.mode("append").save();
        return df;
    }

    protected Dataset<Row> read(long expectedRowCount, SQLContext sql) {
        DataFrameReader reader = sql.read().format("org.apache.cassandra.spark.sparksql.CassandraDataSource");
        reader.options(this.configuration.readOptions);
        Dataset df = reader.load();
        long count = df.count();
        this.logger.info("Found {} records", (Object)count);
        if (count != expectedRowCount) {
            this.logger.error("Expected {} records but found {} records", (Object)expectedRowCount, (Object)count);
            return null;
        }
        return df;
    }

    private static void checkSmallDataFrameEquality(Dataset<Row> expected, Dataset<Row> actual) {
        if (actual == null) {
            throw new NullPointerException("actual dataframe is null");
        }
        if (!actual.exceptAll(expected).isEmpty()) {
            throw new IllegalStateException("The content of the dataframes differs");
        }
    }

    private static JavaRDD<Row> genDataset(JavaSparkContext sc, long records, Integer parallelism) {
        long recordsPerPartition = records / (long)parallelism.intValue();
        long remainder = records - recordsPerPartition * (long)parallelism.intValue();
        List seq = IntStream.range(0, parallelism).boxed().collect(Collectors.toList());
        return sc.parallelize(seq, parallelism.intValue()).mapPartitionsWithIndex((Function2 & Serializable)(index, integerIterator) -> {
            long firstRecordNumber = (long)index.intValue() * recordsPerPartition;
            long recordsToGenerate = index.equals(parallelism) ? remainder : recordsPerPartition;
            return LongStream.range(0L, recordsToGenerate).mapToObj(offset -> {
                long i = firstRecordNumber + offset;
                String courseNameString = String.valueOf(i);
                int courseNameStringLen = courseNameString.length();
                int courseNameMultiplier = 1000 / courseNameStringLen;
                byte[] courseName = AbstractCassandraJob.dupStringAsBytes(courseNameString, courseNameMultiplier);
                return RowFactory.create((Object[])new Object[]{i, courseName, i});
            }).iterator();
        }, false);
    }

    private static byte[] dupStringAsBytes(String string, Integer times) {
        byte[] stringBytes = string.getBytes();
        ByteBuffer buf = ByteBuffer.allocate(stringBytes.length * times);
        for (int i = 0; i < times; ++i) {
            buf.put(stringBytes);
        }
        return buf.array();
    }

    static class JobConfiguration {
        long rowCount = 100000L;
        ImmutableMap<String, String> writeOptions;
        ImmutableMap<String, String> readOptions;

        JobConfiguration(Map<String, String> writeOptions, Map<String, String> readOptions) {
            this.writeOptions = ImmutableMap.copyOf(writeOptions);
            this.readOptions = ImmutableMap.copyOf(readOptions);
        }

        boolean shouldWrite() {
            return !this.writeOptions.isEmpty();
        }

        boolean shouldRead() {
            return !this.readOptions.isEmpty();
        }
    }
}

