/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.msg.jdk;

import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.bridge.CdcBridgeFactory;
import org.apache.cassandra.cdc.api.MessageConverter;
import org.apache.cassandra.cdc.msg.CdcEvent;
import org.apache.cassandra.cdc.msg.RangeTombstone;
import org.apache.cassandra.cdc.msg.Value;
import org.apache.cassandra.cdc.msg.jdk.CdcMessage;
import org.apache.cassandra.cdc.msg.jdk.Column;
import org.apache.cassandra.cdc.msg.jdk.RangeTombstoneMsg;
import org.apache.cassandra.spark.data.CassandraTypes;

public class JdkMessageConverter
implements MessageConverter<Column, RangeTombstoneMsg, CdcMessage> {
    final CassandraTypes types;

    public JdkMessageConverter(CassandraVersion version) {
        this(CdcBridgeFactory.get(version).cassandraTypes());
    }

    public JdkMessageConverter(CassandraTypes types) {
        this.types = types;
    }

    @Override
    public Column toCdcMessage(Value value) {
        return new Column(value.columnName, this.types.parseType(value.columnType), value.getValue());
    }

    @Override
    public RangeTombstoneMsg toCdcMessage(RangeTombstone value) {
        return new RangeTombstoneMsg(this, value);
    }

    @Override
    public CdcMessage toCdcMessage(CdcEvent event) {
        return new CdcMessage(this, event);
    }
}

