/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.partitioner;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import org.apache.cassandra.analytics.stats.Stats;
import org.apache.cassandra.spark.data.PartitionedDataLayer;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.data.SSTablesSupplier;
import org.apache.cassandra.spark.data.partitioner.CassandraInstance;
import org.apache.cassandra.spark.reader.SparkSSTableReader;
import org.apache.cassandra.spark.reader.common.SSTableStreamException;
import org.apache.cassandra.spark.utils.ThrowableUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleReplica
extends SSTablesSupplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleReplica.class);
    private final PartitionedDataLayer dataLayer;
    private final CassandraInstance instance;
    private final Range<BigInteger> range;
    private final int partitionId;
    private final ExecutorService executor;
    private final Stats stats;
    private boolean isRepairPrimary;

    public SingleReplica(@NotNull CassandraInstance instance, @NotNull PartitionedDataLayer dataLayer, @NotNull Range<BigInteger> range, int partitionId, @NotNull ExecutorService executor, boolean isRepairPrimary) {
        this(instance, dataLayer, range, partitionId, executor, (Stats)Stats.DoNothingStats.INSTANCE, isRepairPrimary);
    }

    public SingleReplica(@NotNull CassandraInstance instance, @NotNull PartitionedDataLayer dataLayer, @NotNull Range<BigInteger> range, int partitionId, @NotNull ExecutorService executor, @NotNull Stats stats, boolean isRepairPrimary) {
        this.dataLayer = dataLayer;
        this.instance = instance;
        this.range = range;
        this.partitionId = partitionId;
        this.executor = executor;
        this.stats = stats;
        this.isRepairPrimary = isRepairPrimary;
    }

    public CassandraInstance instance() {
        return this.instance;
    }

    public Range<BigInteger> range() {
        return this.range;
    }

    public boolean isRepairPrimary() {
        return this.isRepairPrimary;
    }

    public void setIsRepairPrimary(boolean isRepairPrimary) {
        this.isRepairPrimary = isRepairPrimary;
    }

    public <T extends SparkSSTableReader> Set<T> openAll(SSTablesSupplier.ReaderOpener<T> readerOpener) {
        try {
            return this.openReplicaAsync(readerOpener).get();
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(exception);
        }
        catch (ExecutionException exception) {
            throw new RuntimeException(ThrowableUtils.rootCause((Throwable)exception));
        }
    }

    <T extends SparkSSTableReader> CompletableFuture<Set<T>> openReplicaAsync(@NotNull SSTablesSupplier.ReaderOpener<T> readerOpener) {
        try {
            long timeNanos = System.nanoTime();
            return ((CompletableFuture)this.dataLayer.listInstance(this.partitionId, this.range, this.instance).thenApply(stream -> {
                this.stats.timeToListSnapshot((SSTablesSupplier)this, System.nanoTime() - timeNanos);
                return stream;
            })).thenCompose(stream -> this.openAll((Stream<SSTable>)stream, readerOpener));
        }
        catch (Throwable throwable) {
            LOGGER.warn("Unexpected error attempting to open SSTable readers for replica node={} token={} dataCenter={}", new Object[]{this.instance().nodeName(), this.instance().token(), this.instance().dataCenter(), throwable});
            CompletableFuture<Set<T>> exceptionally = new CompletableFuture<Set<T>>();
            exceptionally.completeExceptionally(throwable);
            return exceptionally;
        }
    }

    private <T extends SparkSSTableReader> CompletableFuture<Set<T>> openAll(@NotNull Stream<SSTable> stream, @NotNull SSTablesSupplier.ReaderOpener<T> readerOpener) {
        ConcurrentHashMap.KeySetView result = ConcurrentHashMap.newKeySet();
        CompletableFuture[] futures = (CompletableFuture[])stream.peek(SSTable::verify).map(ssTable -> CompletableFuture.runAsync(() -> this.openReader(readerOpener, (SSTable)ssTable, result), this.executor)).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures).thenApply(aVoid -> ImmutableSet.copyOf((Collection)result));
    }

    private <T extends SparkSSTableReader> void openReader(@NotNull SSTablesSupplier.ReaderOpener<T> readerOpener, @NotNull SSTable ssTable, @NotNull Set<T> result) {
        try {
            SparkSSTableReader reader = readerOpener.openReader(ssTable, this.isRepairPrimary);
            if (!reader.ignore()) {
                result.add(reader);
            }
        }
        catch (IOException exception) {
            throw new SSTableStreamException(exception);
        }
    }
}

