/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.partitioner;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.analytics.stats.Stats;
import org.apache.cassandra.spark.data.SSTablesSupplier;
import org.apache.cassandra.spark.data.partitioner.NotEnoughReplicasException;
import org.apache.cassandra.spark.data.partitioner.SingleReplica;
import org.apache.cassandra.spark.reader.SparkSSTableReader;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleReplicas
extends SSTablesSupplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipleReplicas.class);
    @NotNull
    private final Set<SingleReplica> primaryReplicas;
    @NotNull
    private final Set<SingleReplica> backupReplicas;
    @NotNull
    private final Stats stats;

    public MultipleReplicas(@NotNull Set<SingleReplica> primaryReplicas, @NotNull Set<SingleReplica> backupReplicas, @NotNull Stats stats) {
        this.primaryReplicas = ImmutableSet.copyOf(primaryReplicas);
        this.backupReplicas = ImmutableSet.copyOf(backupReplicas);
        this.stats = stats;
    }

    public <T extends SparkSSTableReader> Set<T> openAll(SSTablesSupplier.ReaderOpener<T> readerOpener) {
        if (this.primaryReplicas.isEmpty()) {
            return Collections.emptySet();
        }
        long startTimeNanos = System.nanoTime();
        ConcurrentLinkedQueue<SingleReplica> otherReplicas = new ConcurrentLinkedQueue<SingleReplica>(this.backupReplicas);
        AtomicInteger count = new AtomicInteger(0);
        CountDownLatch latch = new CountDownLatch(this.primaryReplicas.size());
        ConcurrentHashMap.KeySetView result = ConcurrentHashMap.newKeySet();
        for (SingleReplica primaryReplica : this.primaryReplicas) {
            this.openReplicaOrRetry(primaryReplica, readerOpener, result, count, latch, otherReplicas);
        }
        try {
            latch.await();
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(exception);
        }
        if (count.get() < this.primaryReplicas.size()) {
            this.stats.notEnoughReplicas(this.primaryReplicas, this.backupReplicas);
            throw new NotEnoughReplicasException(String.format("Required %d replicas but only %d responded", this.primaryReplicas.size(), count.get()));
        }
        this.stats.openedReplicas(this.primaryReplicas, this.backupReplicas, System.nanoTime() - startTimeNanos);
        return ImmutableSet.copyOf(result);
    }

    private <T extends SparkSSTableReader> void openReplicaOrRetry(@NotNull SingleReplica replica, @NotNull SSTablesSupplier.ReaderOpener<T> readerOpener, @NotNull Set<T> result, @NotNull AtomicInteger count, @NotNull CountDownLatch latch, @NotNull ConcurrentLinkedQueue<SingleReplica> otherReplicas) {
        replica.openReplicaAsync(readerOpener).whenComplete((readers, throwable) -> {
            if (throwable != null) {
                LOGGER.warn("Failed to open SSTableReaders for replica node={} token={} dataCenter={}", new Object[]{replica.instance().nodeName(), replica.instance().token(), replica.instance().dataCenter(), throwable});
                this.stats.failedToOpenReplica((SSTablesSupplier)replica, throwable);
                SingleReplica anotherReplica = (SingleReplica)((Object)((Object)otherReplicas.poll()));
                if (anotherReplica != null) {
                    LOGGER.warn("Retrying on another replica node={} token={} dataCenter={}", new Object[]{anotherReplica.instance().nodeName(), anotherReplica.instance().token(), anotherReplica.instance().dataCenter()});
                    anotherReplica.setIsRepairPrimary(replica.isRepairPrimary());
                    this.openReplicaOrRetry(anotherReplica, readerOpener, result, count, latch, otherReplicas);
                } else {
                    latch.countDown();
                }
                return;
            }
            try {
                result.addAll((Collection)readers);
                count.incrementAndGet();
            }
            finally {
                latch.countDown();
            }
        });
    }
}

