/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.common.schema;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.cassandra.spark.common.schema.ColumnType;

public class UuidType
implements ColumnType<UUID> {
    private UUID getUUID(ByteBuffer raw) {
        return new UUID(raw.getLong(raw.position()), raw.getLong(raw.position() + 8));
    }

    private UUID parseUUID(ByteBuffer buffer, int length) {
        byte[] value = new byte[length];
        buffer.get(value, 0, length);
        return this.getUUID(ByteBuffer.wrap(value));
    }

    @Override
    public UUID parseColumn(ByteBuffer buffer, int length) {
        return this.parseUUID(buffer, length);
    }

    @Override
    public ByteBuffer serialize(UUID value) {
        return ByteBuffer.allocate(16).putLong(0, value.getMostSignificantBits()).putLong(8, value.getLeastSignificantBits());
    }
}

