/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.util.ThreadUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTaskScheduler
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleTaskScheduler.class);
    private final ScheduledExecutorService scheduler;
    private final Map<String, ScheduledFuture<?>> scheduledTasks;
    private boolean isClosed;

    public SimpleTaskScheduler() {
        ThreadFactory tf = ThreadUtil.threadFactory((String)"bulk-write-simple-task-scheduler");
        this.scheduler = Executors.newSingleThreadScheduledExecutor(tf);
        this.scheduledTasks = new HashMap();
        this.isClosed = false;
    }

    public synchronized void schedule(String name, Duration delay, Runnable task) {
        if (this.isClosed() || this.isScheduled(name)) {
            return;
        }
        ScheduledFuture<?> fut = this.scheduler.schedule(new NoThrow(name, task), delay.toMillis(), TimeUnit.MILLISECONDS);
        this.scheduledTasks.put(name, fut);
    }

    public synchronized void schedulePeriodic(String name, Duration interval, Runnable task) {
        if (this.isClosed() || this.isScheduled(name)) {
            return;
        }
        ScheduledFuture<?> fut = this.scheduler.scheduleWithFixedDelay(new NoThrow(name, task), interval.toMillis(), interval.toMillis(), TimeUnit.MILLISECONDS);
        this.scheduledTasks.put(name, fut);
    }

    @VisibleForTesting
    public synchronized boolean unschedule(String name) {
        if (this.isClosed()) {
            return false;
        }
        ScheduledFuture<?> fut = this.scheduledTasks.remove(name);
        if (fut == null) {
            return false;
        }
        return fut.cancel(true);
    }

    @Override
    public synchronized void close() {
        this.isClosed = true;
        this.scheduledTasks.values().forEach(fut -> fut.cancel(true));
        this.scheduler.shutdownNow();
        try {
            boolean terminated = this.scheduler.awaitTermination(2L, TimeUnit.SECONDS);
            if (!terminated) {
                LOGGER.warn("Closing SimpleTaskScheduler times out");
            } else {
                LOGGER.info("SimpleTaskScheduler is closed");
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
            LOGGER.warn("Exception when closing scheduler", (Throwable)exception);
        }
    }

    private boolean isClosed() {
        if (this.isClosed) {
            LOGGER.debug("SimpleTaskScheduler is already closed");
        }
        return this.isClosed;
    }

    private boolean isScheduled(String name) {
        boolean isScheduled = this.scheduledTasks.containsKey(name);
        if (isScheduled) {
            LOGGER.debug("The task has been scheduled already. task={}", (Object)name);
        }
        return isScheduled;
    }

    private static class NoThrow
    implements Runnable {
        private final String name;
        private final Runnable beat;

        NoThrow(String name, Runnable beat) {
            this.beat = beat;
            this.name = name;
        }

        @Override
        public void run() {
            try {
                this.beat.run();
            }
            catch (Exception exception) {
                LOGGER.warn("{} failed to run", (Object)this.name, (Object)exception);
            }
        }
    }
}

