/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Set;
import o.a.c.sidecar.client.shaded.client.SidecarClient;
import o.a.c.sidecar.client.shaded.client.SidecarInstance;
import o.a.c.sidecar.client.shaded.client.SidecarInstancesProvider;
import o.a.c.sidecar.client.shaded.client.SimpleSidecarInstancesProvider;
import org.apache.cassandra.clients.AnalyticsSidecarClient;
import org.apache.cassandra.spark.bulkwriter.BulkSparkConf;
import org.apache.cassandra.spark.validation.CassandraValidation;
import org.apache.cassandra.spark.validation.SidecarValidation;
import org.apache.cassandra.spark.validation.StartupValidatable;
import org.apache.cassandra.spark.validation.StartupValidation;
import org.apache.cassandra.spark.validation.StartupValidator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraContext
implements StartupValidatable,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraContext.class);
    @NotNull
    protected Set<SidecarInstance> clusterConfig;
    private final BulkSparkConf conf;
    private final String clusterId;
    private final transient SidecarClient sidecarClient;

    protected CassandraContext(BulkSparkConf conf, @Nullable String clusterId) {
        this.conf = conf;
        this.clusterId = clusterId;
        this.clusterConfig = this.createClusterConfig();
        this.sidecarClient = this.initializeSidecarClient(conf);
        LOGGER.debug("[{}] Created Cassandra Context", (Object)Thread.currentThread().getName());
    }

    public static CassandraContext create(BulkSparkConf conf, @Nullable String clusterId) {
        return new CassandraContext(conf, clusterId);
    }

    public Set<SidecarInstance> getCluster() {
        return this.clusterConfig;
    }

    public void refreshClusterConfig() {
    }

    @Override
    public void close() {
        try {
            this.sidecarClient.close();
            LOGGER.debug("[{}] Closed Cassandra Context", (Object)Thread.currentThread().getName());
        }
        catch (Throwable throwable) {
            LOGGER.error("Could not shut down CassandraContext.", throwable);
        }
    }

    protected SidecarClient initializeSidecarClient(BulkSparkConf conf) {
        return AnalyticsSidecarClient.from((SidecarInstancesProvider)new SimpleSidecarInstancesProvider(new ArrayList<SidecarInstance>(this.clusterConfig)), conf);
    }

    protected Set<SidecarInstance> createClusterConfig() {
        if (this.clusterId == null) {
            return this.conf.sidecarContactPoints();
        }
        Preconditions.checkState((boolean)this.conf.isCoordinatedWriteConfigured(), (Object)"Expect CoordinatedWriteConfigured but not");
        return this.conf.coordinatedWriteConf().cluster(this.clusterId).sidecarContactPoints();
    }

    public SidecarClient getSidecarClient() {
        return this.sidecarClient;
    }

    public int sidecarPort() {
        if (this.clusterId == null) {
            return this.conf.getEffectiveSidecarPort();
        }
        Preconditions.checkState((boolean)this.conf.isCoordinatedWriteConfigured(), (Object)"Expect CoordinatedWriteConfigured but not");
        return this.conf.coordinatedWriteConf().cluster(this.clusterId).sidecarContactPoints().iterator().next().port();
    }

    protected BulkSparkConf conf() {
        return this.conf;
    }

    protected String clusterId() {
        return this.clusterId;
    }

    @Override
    public void startupValidate() {
        int timeoutSeconds = this.conf.getSidecarRequestTimeoutSeconds();
        StartupValidator.instance().register((StartupValidation)new SidecarValidation(this.sidecarClient, timeoutSeconds));
        StartupValidator.instance().register((StartupValidation)new CassandraValidation(this.sidecarClient, timeoutSeconds));
        StartupValidator.instance().perform();
    }
}

