/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.guardrails;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.db.guardrails.Guardrail;
import org.apache.cassandra.service.ClientState;

public class Values<T>
extends Guardrail {
    private final Function<ClientState, Set<T>> warnedValues;
    private final Function<ClientState, Set<T>> ignoredValues;
    private final Function<ClientState, Set<T>> disallowedValues;
    private final String what;

    public Values(String name, @Nullable String reason, Function<ClientState, Set<T>> warnedValues, Function<ClientState, Set<T>> ignoredValues, Function<ClientState, Set<T>> disallowedValues, String what) {
        super(name, reason);
        this.warnedValues = warnedValues;
        this.ignoredValues = ignoredValues;
        this.disallowedValues = disallowedValues;
        this.what = what;
    }

    public void guard(Set<T> values, @Nullable ClientState state) {
        this.guard(values, x -> {
            throw new AssertionError((Object)String.format("There isn't an ignore action for %s, but value %s is setup to be ignored", this.what, x));
        }, state);
    }

    public void guard(Set<T> values, Consumer<T> ignoreAction, @Nullable ClientState state) {
        Set<T> warned;
        Sets.SetView toWarn;
        Set<T> ignored;
        Sets.SetView toIgnore;
        if (!this.enabled(state)) {
            return;
        }
        Set<T> disallowed = this.disallowedValues.apply(state);
        Sets.SetView toDisallow = Sets.intersection(values, disallowed);
        if (!toDisallow.isEmpty()) {
            this.fail(String.format("Provided values %s are not allowed for %s (disallowed values are: %s)", toDisallow.stream().sorted().collect(Collectors.toList()), this.what, disallowed), state);
        }
        if (!(toIgnore = Sets.intersection(values, ignored = this.ignoredValues.apply(state))).isEmpty()) {
            this.warn(String.format("Ignoring provided values %s as they are not supported for %s (ignored values are: %s)", toIgnore.stream().sorted().collect(Collectors.toList()), this.what, ignored));
            toIgnore.forEach(ignoreAction);
        }
        if (!(toWarn = Sets.intersection(values, warned = this.warnedValues.apply(state))).isEmpty()) {
            this.warn(String.format("Provided values %s are not recommended for %s (warned values are: %s)", toWarn.stream().sorted().collect(Collectors.toList()), this.what, warned));
        }
    }
}

