/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.Duration;
import org.apache.cassandra.cql3.functions.Arguments;
import org.apache.cassandra.cql3.functions.NativeFunction;
import org.apache.cassandra.cql3.functions.NativeFunctions;
import org.apache.cassandra.cql3.functions.NativeScalarFunction;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.DurationType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.db.marshal.TemporalType;
import org.apache.cassandra.db.marshal.TimeType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimeFcts {
    public static Logger logger = LoggerFactory.getLogger(TimeFcts.class);
    public static final NativeFunction minTimeuuidFct = new MinTimeuuidFunction(false);
    public static final NativeFunction maxTimeuuidFct = new MaxTimeuuidFunction(false);
    public static final NativeScalarFunction floorTime = new NativeScalarFunction("floor", (AbstractType)TimeType.instance, new AbstractType[]{TimeType.instance, DurationType.instance}){

        @Override
        protected boolean isPartialApplicationMonotonic(List<ByteBuffer> partialParameters) {
            return partialParameters.get(0) == UNRESOLVED && partialParameters.get(1) != UNRESOLVED;
        }

        @Override
        public ByteBuffer execute(Arguments arguments) {
            if (arguments.containsNulls()) {
                return null;
            }
            long time = arguments.getAsLong(0);
            Duration duration = (Duration)arguments.get(1);
            long floor = Duration.floorTime(time, duration);
            return TimeType.instance.decompose(floor);
        }
    };

    public static void addFunctionsTo(NativeFunctions functions) {
        functions.addAll(new NowFunction("now", TimeUUIDType.instance), new NowFunction("current_timeuuid", TimeUUIDType.instance), new NowFunction("current_timestamp", TimestampType.instance), new NowFunction("current_date", SimpleDateType.instance), new NowFunction("current_time", TimeType.instance), minTimeuuidFct, maxTimeuuidFct, TimeFcts.toDate(TimeUUIDType.instance), TimeFcts.toTimestamp(TimeUUIDType.instance), TimeFcts.toUnixTimestamp(TimeUUIDType.instance), TimeFcts.toUnixTimestamp(TimestampType.instance), TimeFcts.toDate(TimestampType.instance), TimeFcts.toUnixTimestamp(SimpleDateType.instance), TimeFcts.toTimestamp(SimpleDateType.instance), FloorTimestampFunction.newInstance(), FloorTimestampFunction.newInstanceWithStartTimeArgument(), FloorTimeUuidFunction.newInstance(), FloorTimeUuidFunction.newInstanceWithStartTimeArgument(), FloorDateFunction.newInstance(), FloorDateFunction.newInstanceWithStartTimeArgument(), floorTime);
    }

    public static NativeScalarFunction toDate(TemporalType<?> type) {
        return new ToDateFunction(type, false);
    }

    public static NativeScalarFunction toTimestamp(TemporalType<?> type) {
        return new ToTimestampFunction(type, false);
    }

    public static NativeScalarFunction toUnixTimestamp(TemporalType<?> type) {
        return new ToUnixTimestampFunction(type, false);
    }

    public static final class FloorDateFunction
    extends FloorFunction {
        public static FloorDateFunction newInstance() {
            return new FloorDateFunction(SimpleDateType.instance, SimpleDateType.instance, DurationType.instance);
        }

        public static FloorDateFunction newInstanceWithStartTimeArgument() {
            return new FloorDateFunction(SimpleDateType.instance, SimpleDateType.instance, DurationType.instance, SimpleDateType.instance);
        }

        private FloorDateFunction(AbstractType<?> returnType, AbstractType<?> ... argTypes) {
            super(returnType, argTypes);
        }

        @Override
        protected ByteBuffer fromTimeInMillis(long timeInMillis) {
            return SimpleDateType.instance.fromTimeInMillis(timeInMillis);
        }

        @Override
        protected void validateDuration(Duration duration) {
            if (duration.getNanoseconds() != 0L) {
                throw RequestValidations.invalidRequest("The floor on %s values cannot be computed for the %s duration as precision is below 1 day", SimpleDateType.instance.asCQL3Type(), duration);
            }
        }
    }

    public static final class FloorTimeUuidFunction
    extends FloorFunction {
        public static FloorTimeUuidFunction newInstance() {
            return new FloorTimeUuidFunction(TimestampType.instance, TimeUUIDType.instance, DurationType.instance);
        }

        public static FloorTimeUuidFunction newInstanceWithStartTimeArgument() {
            return new FloorTimeUuidFunction(TimestampType.instance, TimeUUIDType.instance, DurationType.instance, TimestampType.instance);
        }

        private FloorTimeUuidFunction(AbstractType<?> returnType, AbstractType<?> ... argTypes) {
            super(returnType, argTypes);
        }

        @Override
        protected ByteBuffer fromTimeInMillis(long timeInMillis) {
            return TimestampType.instance.fromTimeInMillis(timeInMillis);
        }
    }

    public static final class FloorTimestampFunction
    extends FloorFunction {
        public static FloorTimestampFunction newInstance() {
            return new FloorTimestampFunction(TimestampType.instance, TimestampType.instance, DurationType.instance);
        }

        public static FloorTimestampFunction newInstanceWithStartTimeArgument() {
            return new FloorTimestampFunction(TimestampType.instance, TimestampType.instance, DurationType.instance, TimestampType.instance);
        }

        private FloorTimestampFunction(AbstractType<?> returnType, AbstractType<?> ... argTypes) {
            super(returnType, argTypes);
        }

        @Override
        protected ByteBuffer fromTimeInMillis(long timeInMillis) {
            return TimestampType.instance.fromTimeInMillis(timeInMillis);
        }
    }

    private static abstract class FloorFunction
    extends NativeScalarFunction {
        private static final Long ZERO = 0L;

        protected FloorFunction(AbstractType<?> returnType, AbstractType<?> ... argsType) {
            super("floor", returnType, argsType);
            assert (argsType.length == 2 || argsType.length == 3);
        }

        @Override
        protected boolean isPartialApplicationMonotonic(List<ByteBuffer> partialParameters) {
            return partialParameters.get(0) == UNRESOLVED && partialParameters.get(1) != UNRESOLVED && (partialParameters.size() == 2 || partialParameters.get(2) != UNRESOLVED);
        }

        @Override
        public final ByteBuffer execute(Arguments arguments) {
            if (arguments.containsNulls()) {
                return null;
            }
            long time = arguments.getAsLong(0);
            Duration duration = (Duration)arguments.get(1);
            long startingTime = this.getStartingTime(arguments);
            this.validateDuration(duration);
            long floor = Duration.floorTimestamp(time, duration, startingTime);
            return this.fromTimeInMillis(floor);
        }

        private long getStartingTime(Arguments arguments) {
            if (arguments.size() == 3) {
                return arguments.getAsLong(2);
            }
            return ZERO;
        }

        protected void validateDuration(Duration duration) {
            if (!duration.hasMillisecondPrecision()) {
                throw RequestValidations.invalidRequest("The floor cannot be computed for the %s duration as precision is below 1 millisecond", duration);
            }
        }

        protected abstract ByteBuffer fromTimeInMillis(long var1);
    }

    private static class ToUnixTimestampFunction
    extends TemporalConversionFunction {
        private final TemporalType<?> type;

        private ToUnixTimestampFunction(TemporalType<?> type, boolean useLegacyName) {
            super(useLegacyName ? "tounixtimestamp" : "to_unix_timestamp", LongType.instance, type);
            this.type = type;
        }

        @Override
        protected ByteBuffer convertArgument(long timeInMillis) {
            return ByteBufferUtil.bytes(timeInMillis);
        }

        @Override
        public boolean isMonotonic() {
            return true;
        }

        @Override
        public NativeFunction withLegacyName() {
            return new ToUnixTimestampFunction(this.type, true);
        }
    }

    private static class ToTimestampFunction
    extends TemporalConversionFunction {
        private final TemporalType<?> type;

        public ToTimestampFunction(TemporalType<?> type, boolean useLegacyName) {
            super(useLegacyName ? "totimestamp" : "to_timestamp", TimestampType.instance, type);
            this.type = type;
        }

        @Override
        protected ByteBuffer convertArgument(long timeInMillis) {
            return TimestampType.instance.fromTimeInMillis(timeInMillis);
        }

        @Override
        public boolean isMonotonic() {
            return true;
        }

        @Override
        public NativeFunction withLegacyName() {
            return new ToTimestampFunction(this.type, true);
        }
    }

    private static class ToDateFunction
    extends TemporalConversionFunction {
        private final TemporalType<?> type;

        public ToDateFunction(TemporalType<?> type, boolean useLegacyName) {
            super(useLegacyName ? "todate" : "to_date", SimpleDateType.instance, type);
            this.type = type;
        }

        @Override
        protected ByteBuffer convertArgument(long timeInMillis) {
            return SimpleDateType.instance.fromTimeInMillis(timeInMillis);
        }

        @Override
        public boolean isMonotonic() {
            return true;
        }

        @Override
        public NativeFunction withLegacyName() {
            return new ToDateFunction(this.type, true);
        }
    }

    private static final class MaxTimeuuidFunction
    extends TemporalConversionFunction {
        public MaxTimeuuidFunction(boolean legacy) {
            super(legacy ? "maxtimeuuid" : "max_timeuuid", TimeUUIDType.instance, TimestampType.instance);
        }

        @Override
        protected ByteBuffer convertArgument(long timeInMillis) {
            return TimeUUID.maxAtUnixMillis(timeInMillis).toBytes();
        }

        @Override
        public NativeFunction withLegacyName() {
            return new MaxTimeuuidFunction(true);
        }
    }

    private static final class MinTimeuuidFunction
    extends TemporalConversionFunction {
        public MinTimeuuidFunction(boolean legacy) {
            super(legacy ? "mintimeuuid" : "min_timeuuid", TimeUUIDType.instance, TimestampType.instance);
        }

        @Override
        protected ByteBuffer convertArgument(long timeInMillis) {
            return TimeUUID.minAtUnixMillis(timeInMillis).toBytes();
        }

        @Override
        public NativeFunction withLegacyName() {
            return new MinTimeuuidFunction(true);
        }
    }

    public static abstract class TemporalConversionFunction
    extends NativeScalarFunction {
        protected TemporalConversionFunction(String name, AbstractType<?> returnType, AbstractType<?> ... argsType) {
            super(name, returnType, argsType);
        }

        @Override
        public ByteBuffer execute(Arguments arguments) {
            this.beforeExecution();
            if (arguments.containsNulls()) {
                return null;
            }
            return this.convertArgument(arguments.getAsLong(0));
        }

        protected void beforeExecution() {
        }

        protected abstract ByteBuffer convertArgument(long var1);
    }

    private static class NowFunction
    extends NativeScalarFunction {
        private final TemporalType<?> type;

        public NowFunction(String name, TemporalType<?> type) {
            super(name, type, new AbstractType[0]);
            this.type = type;
        }

        @Override
        public ByteBuffer execute(Arguments arguments) {
            return this.type.now();
        }

        @Override
        public boolean isPure() {
            return false;
        }

        @Override
        public NativeFunction withLegacyName() {
            String name = this.name().name;
            return name.contains("current") ? new NowFunction(StringUtils.remove((String)name, (char)'_'), this.type) : null;
        }
    }
}

