/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.fqltool;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.google.common.collect.Sets;
import com.google.common.primitives.Longs;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.statements.BatchStatement;
import org.apache.cassandra.fql.FullQueryLogger;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.utils.binlog.BinLog;

public abstract class FQLQuery
implements Comparable<FQLQuery> {
    public final long queryStartTime;
    public final QueryOptions queryOptions;
    public final int protocolVersion;
    public final QueryState queryState;

    public FQLQuery(String keyspace, int protocolVersion, QueryOptions queryOptions, long queryStartTime, long generatedTimestamp, int generatedNowInSeconds) {
        this.queryStartTime = queryStartTime;
        this.queryOptions = queryOptions;
        this.protocolVersion = protocolVersion;
        this.queryState = this.queryState(keyspace, generatedTimestamp, generatedNowInSeconds);
    }

    public abstract Statement toStatement();

    public abstract BinLog.ReleaseableWriteMarshallable toMarshallable();

    public String keyspace() {
        return this.queryState.getClientState().getRawKeyspace();
    }

    private QueryState queryState(String keyspace, long generatedTimestamp, int generatedNowInSeconds) {
        ClientState clientState = keyspace != null ? ClientState.forInternalCalls((String)keyspace) : ClientState.forInternalCalls();
        return new QueryState(clientState, generatedTimestamp, generatedNowInSeconds);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FQLQuery)) {
            return false;
        }
        FQLQuery fqlQuery = (FQLQuery)o;
        return this.queryStartTime == fqlQuery.queryStartTime && this.protocolVersion == fqlQuery.protocolVersion && this.queryState.getTimestamp() == fqlQuery.queryState.getTimestamp() && Objects.equals(this.queryState.getClientState().getRawKeyspace(), fqlQuery.queryState.getClientState().getRawKeyspace()) && Objects.equals(this.queryOptions.getValues(), fqlQuery.queryOptions.getValues());
    }

    public int hashCode() {
        return Objects.hash(this.queryStartTime, this.queryOptions, this.protocolVersion, this.queryState.getClientState().getRawKeyspace());
    }

    @Override
    public int compareTo(FQLQuery other) {
        return Longs.compare((long)this.queryStartTime, (long)other.queryStartTime);
    }

    public String toString() {
        return "FQLQuery{queryStartTime=" + this.queryStartTime + ", protocolVersion=" + this.protocolVersion + ", queryState='" + this.queryState + '\'' + '}';
    }

    public abstract boolean isDDLStatement();

    public static class Batch
    extends FQLQuery {
        public final BatchStatement.Type batchType;
        public final List<Single> queries;

        public Batch(String keyspace, int protocolVersion, QueryOptions queryOptions, long queryStartTime, long generatedTimestamp, int generatedNowInSeconds, BatchStatement.Type batchType, List<String> queries, List<List<ByteBuffer>> values) {
            super(keyspace, protocolVersion, queryOptions, queryStartTime, generatedTimestamp, generatedNowInSeconds);
            this.batchType = batchType;
            this.queries = new ArrayList<Single>(queries.size());
            for (int i = 0; i < queries.size(); ++i) {
                this.queries.add(new Single(keyspace, protocolVersion, queryOptions, queryStartTime, generatedTimestamp, generatedNowInSeconds, queries.get(i), values.get(i)));
            }
        }

        @Override
        public Statement toStatement() {
            BatchStatement bs = new BatchStatement(this.batchType);
            for (Single query : this.queries) {
                bs.add(query.toStatement());
            }
            bs.setConsistencyLevel(ConsistencyLevel.valueOf((String)this.queryOptions.getConsistency().name()));
            bs.setDefaultTimestamp(this.queryOptions.getTimestamp(this.queryState));
            return bs;
        }

        @Override
        public int compareTo(FQLQuery other) {
            int cmp = super.compareTo(other);
            if (cmp == 0) {
                if (other instanceof Single) {
                    return 1;
                }
                Batch otherBatch = (Batch)other;
                if (this.queries.size() != otherBatch.queries.size()) {
                    return this.queries.size() - otherBatch.queries.size();
                }
                for (int i = 0; i < this.queries.size(); ++i) {
                    cmp = this.queries.get(i).compareTo(otherBatch.queries.get(i));
                    if (cmp == 0) continue;
                    return cmp;
                }
            }
            return cmp;
        }

        @Override
        public BinLog.ReleaseableWriteMarshallable toMarshallable() {
            ArrayList<String> queryStrings = new ArrayList<String>();
            ArrayList<List<ByteBuffer>> values = new ArrayList<List<ByteBuffer>>();
            for (Single q : this.queries) {
                queryStrings.add(q.query);
                values.add(q.values);
            }
            return new FullQueryLogger.Batch(BatchStatement.Type.valueOf((String)this.batchType.name()), queryStrings, values, this.queryOptions, this.queryState, this.queryStartTime);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(super.toString()).append(" batch: ").append(this.batchType).append(':');
            for (Single q : this.queries) {
                sb.append(q.toString()).append(',');
            }
            sb.append("end batch");
            return sb.toString();
        }

        @Override
        public boolean isDDLStatement() {
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Batch)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Batch batch = (Batch)o;
            return this.batchType == batch.batchType && Objects.equals(this.queries, batch.queries);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.batchType, this.queries);
        }
    }

    public static class Single
    extends FQLQuery {
        private static final Set<String> DDL_STATEMENTS = Sets.newHashSet((Object[])new String[]{"CREATE", "ALTER", "DROP"});
        public final String query;
        public final List<ByteBuffer> values;

        public Single(String keyspace, int protocolVersion, QueryOptions queryOptions, long queryStartTime, long generatedTimestamp, int generatedNowInSeconds, String queryString, List<ByteBuffer> values) {
            super(keyspace, protocolVersion, queryOptions, queryStartTime, generatedTimestamp, generatedNowInSeconds);
            this.query = queryString;
            this.values = values;
        }

        @Override
        public String toString() {
            return String.format("%s: Query: [%s], valuecount : %d", super.toString(), this.query, this.values.size());
        }

        @Override
        public boolean isDDLStatement() {
            for (String ddlStmt : DDL_STATEMENTS) {
                if (!this.query.startsWith(ddlStmt)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Statement toStatement() {
            SimpleStatement ss = new SimpleStatement(this.query, this.values.toArray());
            ss.setConsistencyLevel(ConsistencyLevel.valueOf((String)this.queryOptions.getConsistency().name()));
            ss.setDefaultTimestamp(this.queryOptions.getTimestamp(this.queryState));
            return ss;
        }

        @Override
        public BinLog.ReleaseableWriteMarshallable toMarshallable() {
            return new FullQueryLogger.Query(this.query, this.queryOptions, this.queryState, this.queryStartTime);
        }

        @Override
        public int compareTo(FQLQuery other) {
            int cmp = super.compareTo(other);
            if (cmp == 0) {
                if (other instanceof Batch) {
                    return -1;
                }
                Single singleQuery = (Single)other;
                cmp = this.query.compareTo(singleQuery.query);
                if (cmp == 0) {
                    if (this.values.size() != singleQuery.values.size()) {
                        return this.values.size() - singleQuery.values.size();
                    }
                    for (int i = 0; i < this.values.size(); ++i) {
                        cmp = this.values.get(i).compareTo(singleQuery.values.get(i));
                        if (cmp == 0) continue;
                        return cmp;
                    }
                }
            }
            return cmp;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Single)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Single single = (Single)o;
            return Objects.equals(this.query, single.query) && Objects.equals(this.values, single.values);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.query, this.values);
        }
    }
}

