# Apache Camel

[![Maven Central](https://maven-badges.herokuapp.com/maven-central/org.apache.camel/apache-camel/badge.svg?style=flat-square)](https://maven-badges.herokuapp.com/maven-central/org.apache.camel/apache-camel)
[![Javadocs](https://www.javadoc.io/badge/org.apache.camel/apache-camel.svg?color=brightgreen)](https://www.javadoc.io/doc/org.apache.camel/camel-api)
[![Stack Overflow](https://img.shields.io/:stack%20overflow-apache--camel-brightgreen.svg)](http://stackoverflow.com/questions/tagged/apache-camel)
[![Chat](https://img.shields.io/badge/zulip-join_chat-brightgreen.svg)](https://camel.zulipchat.com/)
[![Twitter](https://img.shields.io/twitter/follow/ApacheCamel.svg?label=Follow&style=social)](https://twitter.com/ApacheCamel)


[Apache Camel](https://camel.apache.org/) is an Open Source integration framework that empowers you to quickly and easily integrate various systems consuming or producing data.

### Introduction

Camel empowers you to define routing and mediation rules in a variety of domain-specific languages (DSL, such as Java, XML, Groovy and YAML). This means you get smart completion of routing rules in your IDE, whether in a Java or XML editor.

Apache Camel uses URIs to enable easier integration with all kinds of
transport or messaging model including HTTP, ActiveMQ, JMS, JBI, SCA, MINA
or CXF together with working with pluggable Data Format options.
Apache Camel is a small library that has minimal dependencies for easy embedding
in any Java application. Apache Camel lets you work with the same API regardless of the 
transport type, making it possible to interact with all the components provided out-of-the-box, 
with a good understanding of the API.

Apache Camel has powerful Bean Binding and integrated seamlessly with
popular frameworks such as Spring, Quarkus, and CDI.

Apache Camel has extensive testing support allowing you to easily
unit test your routes.

## Components

Apache Camel comes alongside several artifacts with components, data formats, languages, and kinds.
The up-to-date list is available online at the Camel website:

* Components: <https://camel.apache.org/components/latest/>
* Data Formats: <https://camel.apache.org/components/latest/dataformats/>
* Languages: <https://camel.apache.org/components/latest/languages/>
* Miscellaneous: <https://camel.apache.org/components/latest/#_miscellaneous_components>

## Examples

Apache Camel comes with many examples.
The up to date list is available online at GitHub:

* Examples: <https://github.com/apache/camel-examples/tree/main#welcome-to-the-apache-camel-examples>

## Getting Started

To help you get started, try the following links:

**Getting Started**

<https://camel.apache.org/getting-started.html>

The beginner examples are another powerful alternative pathway for getting started with Apache Camel.

* Examples: <https://github.com/apache/camel-examples/tree/main#welcome-to-the-apache-camel-examples>

**Building**

<https://camel.apache.org/camel-core/contributing/>

**Contributions**

We welcome all kinds of contributions, the details of which are specified here:

<https://github.com/apache/camel/blob/main/CONTRIBUTING.md>


Please refer to the website for details of finding the issue tracker, 
email lists, GitHub, chat

Website: <https://camel.apache.org/>

GitHub (source): <https://github.com/apache/camel>

Issue tracker: <https://issues.apache.org/jira/projects/CAMEL>

Mailing-list: <https://camel.apache.org/community/mailing-list/>

Chat: <https://camel.zulipchat.com/>

StackOverflow: <https://stackoverflow.com/questions/tagged/apache-camel>

Twitter: <https://twitter.com/ApacheCamel>


**Support**

For additional help, support, we recommend referencing this page first:

<https://camel.apache.org/community/support/>

**Getting Help**

If you get stuck somewhere, please feel free to reach out to us on either StackOverflow, Chat, or the email mailing list.

Please help us make Apache Camel better — we appreciate any feedback you may have.

Enjoy!

-----------------
The Camel riders!

# Licensing

The terms for software licensing are detailed in the `LICENSE.txt` file,  
located in the working directory.
