/*
 * Camel ApiMethod Enumeration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.google.drive.internal;

import java.lang.reflect.Method;
import java.util.List;

import com.google.api.services.drive.Drive.Comments;

import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;

import static org.apache.camel.support.component.ApiMethodArg.arg;
import static org.apache.camel.support.component.ApiMethodArg.setter;

/**
 * Camel {@link ApiMethod} Enumeration for com.google.api.services.drive.Drive$Comments
 */
public enum DriveCommentsApiMethod implements ApiMethod {

    CREATE(
        com.google.api.services.drive.Drive.Comments.Create.class,
        "create",
        arg("fileId", String.class),
        arg("content", com.google.api.services.drive.model.Comment.class)),

    DELETE(
        com.google.api.services.drive.Drive.Comments.Delete.class,
        "delete",
        arg("fileId", String.class),
        arg("commentId", String.class)),

    GET(
        com.google.api.services.drive.Drive.Comments.Get.class,
        "get",
        arg("fileId", String.class),
        arg("commentId", String.class),
        setter("includeDeleted", Boolean.class)),

    LIST(
        com.google.api.services.drive.Drive.Comments.List.class,
        "list",
        arg("fileId", String.class),
        setter("includeDeleted", Boolean.class),
        setter("pageSize", Integer.class),
        setter("pageToken", String.class),
        setter("startModifiedTime", String.class)),

    UPDATE(
        com.google.api.services.drive.Drive.Comments.Update.class,
        "update",
        arg("fileId", String.class),
        arg("commentId", String.class),
        arg("content", com.google.api.services.drive.model.Comment.class));

    private final ApiMethod apiMethod;

    DriveCommentsApiMethod(Class<?> resultType, String name, ApiMethodArg... args) {
        this.apiMethod = new ApiMethodImpl(Comments.class, resultType, name, args);
    }

    @Override
    public String getName() { return apiMethod.getName(); }

    @Override
    public Class<?> getResultType() { return apiMethod.getResultType(); }

    @Override
    public List<String> getArgNames() { return apiMethod.getArgNames(); }

    @Override
    public List<String> getSetterArgNames() { return apiMethod.getSetterArgNames(); }

    @Override
    public List<Class<?>> getArgTypes() { return apiMethod.getArgTypes(); }

    @Override
    public Method getMethod() { return apiMethod.getMethod(); }
}
