/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.perf.test.basic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.perf.test.BasicState;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

public class ExtendedEnumTest {
    @Benchmark
    @OperationsPerInvocation(value=10000)
    public void encode(TestStateEncode state) throws Exception {
        Encoder e = state.encoder;
        GenericDatumWriter writer = new GenericDatumWriter(state.schema);
        for (int i = 0; i < state.getBatchSize(); i += 4) {
            writer.write((Object)state.testData[i + 0], e);
            writer.write((Object)state.testData[i + 1], e);
            writer.write((Object)state.testData[i + 2], e);
            writer.write((Object)state.testData[i + 3], e);
        }
    }

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public void decode(Blackhole blackHole, TestStateDecode state) throws Exception {
        Decoder d = state.decoder;
        GenericDatumReader reader = new GenericDatumReader(state.schema);
        for (int i = 0; i < state.getBatchSize(); ++i) {
            Object o = reader.read(null, d);
            blackHole.consume(o);
        }
    }

    @State(value=Scope.Thread)
    public static class TestStateDecode
    extends BasicState {
        private static final String ENUM_SCHEMA = "{ \"type\": \"enum\", \"name\":\"E\", \"symbols\": [\"A\",\"B\",\"C\",\"D\",\"E\"] }";
        private final Schema schema = new Schema.Parser().parse(this.mkSchema("{ \"type\": \"enum\", \"name\":\"E\", \"symbols\": [\"A\",\"B\",\"C\",\"D\",\"E\"] }"));
        private byte[] testData;
        private Decoder decoder;

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Encoder encoder = super.newEncoder(true, (OutputStream)baos);
            GenericDatumWriter writer = new GenericDatumWriter(this.schema);
            Schema enumSchema = this.schema.getField("f").schema();
            for (int i = 0; i < this.getBatchSize(); ++i) {
                GenericData.Record rec = new GenericData.Record(this.schema);
                int tag = super.getRandom().nextInt(2);
                rec.put("f", GenericData.get().createEnum((String)enumSchema.getEnumSymbols().get(tag), enumSchema));
                writer.write((Object)rec, encoder);
            }
            this.testData = baos.toByteArray();
        }

        private String mkSchema(String subschema) {
            return "{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f\", \"type\": " + subschema + "}\n] }";
        }

        @Setup(value=Level.Invocation)
        public void doSetupInvocation() throws Exception {
            this.decoder = super.newDecoder(this.testData);
        }
    }

    @State(value=Scope.Thread)
    public static class TestStateEncode
    extends BasicState {
        private static final String ENUM_SCHEMA = "{ \"type\": \"enum\", \"name\":\"E\", \"symbols\": [\"A\", \"B\"] }";
        private final Schema schema = new Schema.Parser().parse(this.mkSchema("{ \"type\": \"enum\", \"name\":\"E\", \"symbols\": [\"A\", \"B\"] }"));
        private GenericRecord[] testData;
        private Encoder encoder;

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws Exception {
            this.encoder = super.newEncoder(false, this.getNullOutputStream());
            this.testData = new GenericRecord[this.getBatchSize()];
            Schema enumSchema = this.schema.getField("f").schema();
            for (int i = 0; i < this.getBatchSize(); ++i) {
                GenericData.Record rec = new GenericData.Record(this.schema);
                int tag = super.getRandom().nextInt(2);
                rec.put("f", GenericData.get().createEnum((String)enumSchema.getEnumSymbols().get(tag), enumSchema));
                this.testData[i] = rec;
            }
        }

        private String mkSchema(String subschema) {
            return "{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f\", \"type\": " + subschema + "}\n] }";
        }
    }
}

