/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Divert;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBindingPlugin;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederation;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConsumer;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConsumerConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationMetrics;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.ActiveMQServerAMQPFederationPlugin;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumer;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromResourcePolicy;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMQPFederationLocalPolicyManager
extends AMQPFederationPolicyManager
implements ActiveMQServerBindingPlugin {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected volatile AMQPFederationConsumerConfiguration configuration;

    public AMQPFederationLocalPolicyManager(AMQPFederation federation, AMQPFederationMetrics metrics, FederationReceiveFromResourcePolicy policy) throws ActiveMQException {
        super(federation, metrics, policy.getPolicyName(), policy.getPolicyType());
    }

    public abstract FederationReceiveFromResourcePolicy getPolicy();

    protected AMQPFederationConsumerConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    protected final void handleManagerInitialized() {
        this.server.registerBrokerPlugin((ActiveMQServerBasePlugin)this);
        try {
            this.federation.registerLocalPolicyManagement(this);
        }
        catch (Exception e) {
            logger.trace("Error while attempting to add local policy control to management", (Throwable)e);
        }
    }

    @Override
    protected final void handleManagerStarted() {
        if (this.isActive()) {
            this.scanAllBindings();
        }
    }

    @Override
    protected final void handleManagerStopped() {
        this.safeCleanupManagerResources(false);
    }

    @Override
    protected final void handleManagerShutdown() {
        this.server.unRegisterBrokerPlugin((ActiveMQServerBasePlugin)this);
        try {
            this.federation.unregisterLocalPolicyManagement(this);
        }
        catch (Exception e) {
            logger.trace("Error while attempting to remove local policy control to management", (Throwable)e);
        }
        this.safeCleanupManagerResources(false);
    }

    @Override
    protected final void handleConnectionInterrupted() {
        this.safeCleanupManagerResources(true);
    }

    @Override
    protected final void handleConnectionRestored() {
        this.configuration = new AMQPFederationConsumerConfiguration(this.federation.getConfiguration(), this.getPolicy().getProperties());
        this.updateStateAfterConnect(this.configuration, this.session);
        if (this.isActive()) {
            this.scanAllBindings();
        }
    }

    protected abstract void updateStateAfterConnect(AMQPFederationConsumerConfiguration var1, AMQPSessionContext var2);

    protected abstract void scanAllBindings();

    protected abstract void safeCleanupManagerResources(boolean var1);

    protected synchronized void tryCloseFederationConsumer(AMQPFederationConsumer federationConsuner) {
        if (federationConsuner != null) {
            try {
                if (!federationConsuner.isClosed()) {
                    this.signalPluginBeforeCloseFederationConsumer(federationConsuner);
                    federationConsuner.close();
                    this.signalPluginAfterCloseFederationConsumer(federationConsuner);
                }
            }
            catch (Exception ignore) {
                logger.trace("Caught error on attempted close of existing federation consumer", (Throwable)ignore);
            }
        }
    }

    protected final void signalPluginBeforeCreateFederationConsumer(FederationConsumerInfo info) {
        try {
            this.server.callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin) {
                    ((ActiveMQServerAMQPFederationPlugin)plugin).beforeCreateFederationConsumer(info);
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("beforeCreateFederationConsumer", (Throwable)t);
        }
    }

    protected final void signalPluginAfterCreateFederationConsumer(FederationConsumer consumer) {
        try {
            this.server.callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin) {
                    ((ActiveMQServerAMQPFederationPlugin)plugin).afterCreateFederationConsumer(consumer);
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("afterCreateFederationConsumer", (Throwable)t);
        }
    }

    protected final void signalPluginBeforeCloseFederationConsumer(FederationConsumer consumer) {
        try {
            this.server.callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin) {
                    ((ActiveMQServerAMQPFederationPlugin)plugin).beforeCloseFederationConsumer(consumer);
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("beforeCloseFederationConsumer", (Throwable)t);
        }
    }

    protected final void signalPluginAfterCloseFederationConsumer(FederationConsumer consumer) {
        try {
            this.server.callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin) {
                    ((ActiveMQServerAMQPFederationPlugin)plugin).afterCloseFederationConsumer(consumer);
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("afterCloseFederationConsumer", (Throwable)t);
        }
    }

    protected final boolean isPluginBlockingFederationConsumerCreate(AddressInfo address) {
        AtomicBoolean canCreate = new AtomicBoolean(true);
        try {
            this.server.callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin && canCreate.get()) {
                    canCreate.set(((ActiveMQServerAMQPFederationPlugin)plugin).shouldCreateFederationConsumerForAddress(address));
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("shouldCreateFederationConsumerForAddress", (Throwable)t);
        }
        return !canCreate.get();
    }

    protected final boolean isPluginBlockingFederationConsumerCreate(Divert divert, Queue queue) {
        AtomicBoolean canCreate = new AtomicBoolean(true);
        try {
            this.server.callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin && canCreate.get()) {
                    canCreate.set(((ActiveMQServerAMQPFederationPlugin)plugin).shouldCreateFederationConsumerForDivert(divert, queue));
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("shouldCreateFederationConsumerForDivert", (Throwable)t);
        }
        return !canCreate.get();
    }

    protected final boolean isPluginBlockingFederationConsumerCreate(Queue queue) {
        AtomicBoolean canCreate = new AtomicBoolean(true);
        try {
            this.server.callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin && canCreate.get()) {
                    canCreate.set(((ActiveMQServerAMQPFederationPlugin)plugin).shouldCreateFederationConsumerForQueue(queue));
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("shouldCreateFederationConsumerForQueue", (Throwable)t);
        }
        return !canCreate.get();
    }
}

